/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import java.lang.reflect.Type;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

@JsonAdapter(value=Serializer.class)
public enum Platform {
    BIT_32("32"),
    BIT_64("64"),
    UNKNOWN("unknown");

    private final String bit;
    public static final boolean IS_64_BIT;
    public static final Platform PLATFORM;

    private Platform(String bit) {
        this.bit = bit;
    }

    public String getBit() {
        return this.bit;
    }

    static {
        IS_64_BIT = OperatingSystem.SYSTEM_ARCHITECTURE.contains("64");
        PLATFORM = IS_64_BIT ? BIT_64 : BIT_32;
    }

    public static class Serializer
    implements JsonSerializer<Platform>,
    JsonDeserializer<Platform> {
        @Override
        public JsonElement serialize(Platform t, Type type, JsonSerializationContext jsc) {
            if (t == null) {
                return null;
            }
            switch (t) {
                case BIT_32: {
                    return new JsonPrimitive(0);
                }
                case BIT_64: {
                    return new JsonPrimitive(1);
                }
            }
            return new JsonPrimitive(-1);
        }

        @Override
        public Platform deserialize(JsonElement je, Type type, JsonDeserializationContext jdc) throws JsonParseException {
            if (je == null) {
                return null;
            }
            switch (je.getAsInt()) {
                case 0: {
                    return BIT_32;
                }
                case 1: {
                    return BIT_64;
                }
            }
            return UNKNOWN;
        }
    }
}

