/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.platform;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class CommandBuilder {
    private final OperatingSystem os;
    private List<Item> raw = new LinkedList<Item>();

    public CommandBuilder() {
        this(OperatingSystem.CURRENT_OS);
    }

    public CommandBuilder(OperatingSystem os) {
        this.os = os;
    }

    private String parse(String s) {
        if (OperatingSystem.WINDOWS == this.os) {
            return CommandBuilder.parseBatch(s);
        }
        return CommandBuilder.parseShell(s);
    }

    public CommandBuilder add(String ... args) {
        for (String s : args) {
            this.raw.add(new Item(s, true));
        }
        return this;
    }

    public CommandBuilder addAll(Collection<String> args) {
        for (String s : args) {
            this.raw.add(new Item(s, true));
        }
        return this;
    }

    public CommandBuilder addWithoutParsing(String ... args) {
        for (String s : args) {
            this.raw.add(new Item(s, false));
        }
        return this;
    }

    public CommandBuilder addAllWithoutParsing(Collection<String> args) {
        for (String s : args) {
            this.raw.add(new Item(s, false));
        }
        return this;
    }

    public boolean removeIf(Predicate<String> pred) {
        return this.raw.removeIf((? super E i) -> pred.test(i.arg));
    }

    public String toString() {
        return String.join((CharSequence)" ", this.raw.stream().map(i -> i.parse ? this.parse(i.arg) : i.arg).collect(Collectors.toList()));
    }

    public List<String> asList() {
        return this.raw.stream().map(i -> i.arg).collect(Collectors.toList());
    }

    private static String parseBatch(String s) {
        String escape = " \t\"^&<>|";
        if (StringUtils.containsOne(s, escape.toCharArray())) {
            return '\"' + s.replace("\\", "\\\\").replace("\"", "\\\"") + '\"';
        }
        return s;
    }

    private static String parseShell(String s) {
        String escaping = " \t\"!#$&'()*,;<=>?[\\]^`{|}~";
        String escaped = "\"$&`";
        if (s.indexOf(32) >= 0 || s.indexOf(9) >= 0 || StringUtils.containsOne(s, escaping.toCharArray())) {
            for (char ch : escaped.toCharArray()) {
                s = s.replace("" + ch, "\\" + ch);
            }
            return '\"' + s + '\"';
        }
        return s;
    }

    private static class Item {
        String arg;
        boolean parse;

        Item(String arg, boolean parse) {
            this.arg = arg;
            this.parse = parse;
        }

        public String toString() {
            return this.parse ? (OperatingSystem.WINDOWS == OperatingSystem.CURRENT_OS ? CommandBuilder.parseBatch(this.arg) : CommandBuilder.parseShell(this.arg)) : this.arg;
        }
    }
}

