/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public final class IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    private IOUtils() {
    }

    public static byte[] readFullyWithoutClosing(InputStream stream) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        IOUtils.copyTo(stream, result);
        return result.toByteArray();
    }

    public static ByteArrayOutputStream readFully(InputStream stream) throws IOException {
        try (InputStream is = stream;){
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            IOUtils.copyTo(is, result);
            ByteArrayOutputStream byteArrayOutputStream = result;
            return byteArrayOutputStream;
        }
    }

    public static byte[] readFullyAsByteArray(InputStream stream) throws IOException {
        return IOUtils.readFully(stream).toByteArray();
    }

    public static String readFullyAsString(InputStream stream) throws IOException {
        return IOUtils.readFully(stream).toString();
    }

    public static String readFullyAsString(InputStream stream, Charset charset) throws IOException {
        return IOUtils.readFully(stream).toString(charset.name());
    }

    public static void write(String text, OutputStream outputStream) throws IOException {
        IOUtils.write(text.getBytes(), outputStream);
    }

    public static void write(byte[] bytes, OutputStream outputStream) throws IOException {
        IOUtils.copyTo(new ByteArrayInputStream(bytes), outputStream);
    }

    public static void copyTo(InputStream src, OutputStream dest) throws IOException {
        IOUtils.copyTo(src, dest, new byte[8192]);
    }

    public static void copyTo(InputStream src, OutputStream dest, byte[] buf) throws IOException {
        int len;
        while ((len = src.read(buf)) != -1) {
            dest.write(buf, 0, len);
        }
    }
}

