/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.ui.CrashWindow;
import org.jackhuang.hmcl.upgrade.IntegrityChecker;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public class CrashReporter
implements Thread.UncaughtExceptionHandler {
    private static final Map<String, String> SOURCE = new HashMap<String, String>(){
        {
            this.put("javafx.fxml.LoadException", I18n.i18n("crash.NoClassDefFound"));
            this.put("Location is not set", I18n.i18n("crash.NoClassDefFound"));
            this.put("UnsatisfiedLinkError", I18n.i18n("crash.user_fault"));
            this.put("java.lang.NoClassDefFoundError", I18n.i18n("crash.NoClassDefFound"));
            this.put("org.jackhuang.hmcl.util.ResourceNotFoundError", I18n.i18n("crash.NoClassDefFound"));
            this.put("java.lang.VerifyError", I18n.i18n("crash.NoClassDefFound"));
            this.put("java.lang.NoSuchMethodError", I18n.i18n("crash.NoClassDefFound"));
            this.put("java.lang.NoSuchFieldError", I18n.i18n("crash.NoClassDefFound"));
            this.put("javax.imageio.IIOException", I18n.i18n("crash.NoClassDefFound"));
            this.put("netscape.javascript.JSException", I18n.i18n("crash.NoClassDefFound"));
            this.put("java.lang.IncompatibleClassChangeError", I18n.i18n("crash.NoClassDefFound"));
            this.put("java.lang.ClassFormatError", I18n.i18n("crash.NoClassDefFound"));
            this.put("com.sun.javafx.css.StyleManager.findMatchingStyles", I18n.i18n("launcher.update_java"));
            this.put("NoSuchAlgorithmException", "Has your operating system been installed completely or is a ghost system?");
        }
    };
    private static Set<String> CAUGHT_EXCEPTIONS = Collections.newSetFromMap(new ConcurrentHashMap());
    private final boolean showCrashWindow;

    private boolean checkThrowable(Throwable e) {
        String s = StringUtils.getStackTrace(e);
        for (Map.Entry<String, String> entry : SOURCE.entrySet()) {
            if (!s.contains(entry.getKey())) continue;
            if (StringUtils.isNotBlank(entry.getValue())) {
                String info = entry.getValue();
                Logging.LOG.severe(info);
                try {
                    Alert alert = new Alert(Alert.AlertType.INFORMATION, info, new ButtonType[0]);
                    alert.setTitle(I18n.i18n("message.info"));
                    alert.setHeaderText(I18n.i18n("message.info"));
                    alert.showAndWait();
                }
                catch (Throwable t) {
                    Logging.LOG.log(Level.SEVERE, "Unable to show message", t);
                }
            }
            return false;
        }
        return true;
    }

    public CrashReporter(boolean showCrashWindow) {
        this.showCrashWindow = showCrashWindow;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Logging.LOG.log(Level.SEVERE, "Uncaught exception in thread " + t.getName(), e);
        try {
            String stackTrace = StringUtils.getStackTrace(e);
            if (!stackTrace.contains("org.jackhuang")) {
                return;
            }
            if (CAUGHT_EXCEPTIONS.contains(stackTrace)) {
                return;
            }
            CAUGHT_EXCEPTIONS.add(stackTrace);
            String text = "---- Hello Minecraft! Crash Report ----\n  Version: " + Metadata.VERSION + "\n  Time: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()) + "\n  Thread: " + t.toString() + "\n\n  Content: \n    " + stackTrace + "\n\n-- System Details --\n  Operating System: " + System.getProperty("os.name") + ' ' + OperatingSystem.SYSTEM_VERSION + "\n  Java Version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + "\n  Java VM Version: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor") + "\n  JVM Max Memory: " + Runtime.getRuntime().maxMemory() + "\n  JVM Total Memory: " + Runtime.getRuntime().totalMemory() + "\n  JVM Free Memory: " + Runtime.getRuntime().freeMemory() + "\n";
            Logging.LOG.log(Level.SEVERE, text);
            Platform.runLater(() -> {
                if (this.checkThrowable(e)) {
                    if (this.showCrashWindow) {
                        new CrashWindow(text).show();
                    }
                    if (!UpdateChecker.isOutdated() && IntegrityChecker.isSelfVerified()) {
                        this.reportToServer(text);
                    }
                }
            });
        }
        catch (Throwable handlingException) {
            Logging.LOG.log(Level.SEVERE, "Unable to handle uncaught exception", handlingException);
        }
    }

    private void reportToServer(String text) {
        Thread t = new Thread(() -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("crash_report", text);
            map.put("version", Metadata.VERSION);
            map.put("log", Logging.getLogs());
            try {
                String response = NetworkUtils.doPost(NetworkUtils.toURL("https://hmcl.huangyuhui.net/hmcl/crash.php"), map);
                if (StringUtils.isNotBlank(response)) {
                    Logging.LOG.log(Level.SEVERE, "Crash server response: " + response);
                }
            }
            catch (IOException ex) {
                Logging.LOG.log(Level.SEVERE, "Unable to post HMCL server.", ex);
            }
        });
        t.setDaemon(true);
        t.start();
    }
}

