/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.wizard;

import java.util.Map;
import java.util.Queue;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.task.TaskListener;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.TaskExecutorDialogPane;
import org.jackhuang.hmcl.ui.wizard.AbstractWizardDisplayer;
import org.jackhuang.hmcl.ui.wizard.WizardProvider;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

public abstract class TaskExecutorDialogWizardDisplayer
extends AbstractWizardDisplayer {
    public TaskExecutorDialogWizardDisplayer(Queue<Object> cancelQueue) {
        super(cancelQueue);
    }

    @Override
    public void handleTask(final Map<String, Object> settings, Task<?> task) {
        TaskExecutorDialogPane pane = new TaskExecutorDialogPane(it -> {
            it.fireEvent((Event)new DialogCloseEvent());
            this.onEnd();
        });
        pane.setTitle(I18n.i18n("message.doing"));
        if (settings.containsKey("title")) {
            Object title = settings.get("title");
            if (title instanceof StringProperty) {
                pane.titleProperty().bind((ObservableValue)((StringProperty)title));
            } else if (title instanceof String) {
                pane.setTitle((String)title);
            }
        }
        FXUtils.runInFX(() -> {
            TaskExecutor executor = task.executor(new TaskListener(){

                @Override
                public void onStop(boolean success, TaskExecutor executor) {
                    FXUtils.runInFX(() -> {
                        if (success) {
                            if (settings.containsKey("success_message") && settings.get("success_message") instanceof String) {
                                Controllers.dialog((String)settings.get("success_message"), null, MessageDialogPane.MessageType.FINE, () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                            } else if (!settings.containsKey("forbid_success_message")) {
                                Controllers.dialog(I18n.i18n("message.success"), null, MessageDialogPane.MessageType.FINE, () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                            }
                        } else {
                            if (executor.getException() == null) {
                                return;
                            }
                            String appendix = StringUtils.getStackTrace(executor.getException());
                            if (settings.get("failure_callback") instanceof WizardProvider.FailureCallback) {
                                ((WizardProvider.FailureCallback)settings.get("failure_callback")).onFail(settings, executor.getException(), () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                            } else if (settings.get("failure_message") instanceof String) {
                                Controllers.dialog(appendix, (String)settings.get("failure_message"), MessageDialogPane.MessageType.ERROR, () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                            } else if (!settings.containsKey("forbid_failure_message")) {
                                Controllers.dialog(appendix, I18n.i18n("wizard.failed"), MessageDialogPane.MessageType.ERROR, () -> TaskExecutorDialogWizardDisplayer.this.onEnd());
                            }
                        }
                    });
                }
            });
            pane.setExecutor(executor);
            Controllers.dialog((Region)pane);
            executor.start();
        });
    }
}

