/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.download.game.GameAssetDownloadTask;
import org.jackhuang.hmcl.game.GameDirectoryType;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.LauncherHelper;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.ui.construct.Validator;
import org.jackhuang.hmcl.ui.download.ModpackInstallWizardProvider;
import org.jackhuang.hmcl.ui.export.ExportWizardProvider;
import org.jackhuang.hmcl.ui.versions.VersionSettingsPage;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public class Versions {
    public static void deleteVersion(Profile profile, String version) {
        boolean isIndependent = profile.getVersionSetting(version).getGameDirType() == GameDirectoryType.VERSION_FOLDER;
        boolean isMovingToTrashSupported = FileUtils.isMovingToTrashSupported();
        String message = isIndependent ? I18n.i18n("version.manage.remove.confirm.independent", version) : (isMovingToTrashSupported ? I18n.i18n("version.manage.remove.confirm.trash", version, version + "_removed") : I18n.i18n("version.manage.remove.confirm", version));
        Controllers.confirm(message, I18n.i18n("message.confirm"), () -> profile.getRepository().removeVersionFromDisk(version), null);
    }

    public static CompletableFuture<String> renameVersion(Profile profile, String version) {
        return Controllers.prompt(I18n.i18n("version.manage.rename.message"), (newName, resolve, reject) -> {
            if (!OperatingSystem.isNameValid(newName)) {
                reject.accept(I18n.i18n("install.new_game.malformed"));
                return;
            }
            if (profile.getRepository().renameVersion(version, (String)newName)) {
                profile.getRepository().refreshVersionsAsync().start();
                resolve.run();
            } else {
                reject.accept(I18n.i18n("version.manage.rename.fail"));
            }
        }, version);
    }

    public static void exportVersion(Profile profile, String version) {
        Controllers.getDecorator().startWizard(new ExportWizardProvider(profile, version), I18n.i18n("modpack.wizard"));
    }

    public static void openFolder(Profile profile, String version) {
        FXUtils.openFolder(profile.getRepository().getRunDirectory(version));
    }

    public static void duplicateVersion(Profile profile, String version) {
        Controllers.prompt(new PromptDialogPane.Builder(I18n.i18n("version.manage.duplicate.prompt"), (res, resolve, reject) -> {
            String newVersionName = (String)((PromptDialogPane.Builder.StringQuestion)res.get(0)).getValue();
            boolean copySaves = (Boolean)((PromptDialogPane.Builder.BooleanQuestion)res.get(1)).getValue();
            Task.runAsync(() -> profile.getRepository().duplicateVersion(version, newVersionName, copySaves)).thenComposeAsync(profile.getRepository().refreshVersionsAsync()).whenComplete(Schedulers.javafx(), (result, exception) -> {
                if (exception == null) {
                    resolve.run();
                } else {
                    reject.accept(StringUtils.getStackTrace(exception));
                    profile.getRepository().removeVersionFromDisk(newVersionName);
                }
            }).start();
        }).addQuestion(new PromptDialogPane.Builder.StringQuestion(I18n.i18n("version.manage.duplicate.confirm"), version, new Validator(I18n.i18n("install.new_game.already_exists"), newVersionName -> !profile.getRepository().hasVersion((String)newVersionName)))).addQuestion(new PromptDialogPane.Builder.BooleanQuestion(I18n.i18n("version.manage.duplicate.duplicate_save"), false)));
    }

    public static void updateVersion(Profile profile, String version) {
        Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(profile, version));
    }

    public static void updateGameAssets(Profile profile, String version) {
        TaskExecutor executor = new GameAssetDownloadTask(profile.getDependency(), profile.getRepository().getVersion(version), true, true).executor();
        Controllers.taskDialog(executor, I18n.i18n("version.manage.redownload_assets_index"));
        executor.start();
    }

    public static void cleanVersion(Profile profile, String id) {
        try {
            profile.getRepository().clean(id);
        }
        catch (IOException e) {
            Logging.LOG.log(Level.WARNING, "Unable to clean game directory", e);
        }
    }

    public static void generateLaunchScript(Profile profile, String id) {
        if (Versions.checkForLaunching(profile, id)) {
            HMCLGameRepository repository = profile.getRepository();
            FileChooser chooser = new FileChooser();
            if (repository.getRunDirectory(id).isDirectory()) {
                chooser.setInitialDirectory(repository.getRunDirectory(id));
            }
            chooser.setTitle(I18n.i18n("version.launch_script.save"));
            chooser.getExtensionFilters().add((Object)(OperatingSystem.CURRENT_OS == OperatingSystem.WINDOWS ? new FileChooser.ExtensionFilter(I18n.i18n("extension.bat"), new String[]{"*.bat"}) : new FileChooser.ExtensionFilter(I18n.i18n("extension.sh"), new String[]{"*.sh"})));
            File file = chooser.showSaveDialog((Window)Controllers.getStage());
            if (file != null) {
                new LauncherHelper(profile, Accounts.getSelectedAccount(), id).makeLaunchScript(file);
            }
        }
    }

    public static void launch(Profile profile, String id) {
        if (Versions.checkForLaunching(profile, id)) {
            new LauncherHelper(profile, Accounts.getSelectedAccount(), id).launch();
        }
    }

    public static void testGame(Profile profile, String id) {
        if (Versions.checkForLaunching(profile, id)) {
            LauncherHelper helper = new LauncherHelper(profile, Accounts.getSelectedAccount(), id);
            helper.setTestMode();
            helper.launch();
        }
    }

    private static boolean checkForLaunching(Profile profile, String id) {
        if (Accounts.getSelectedAccount() == null) {
            Controllers.getRootPage().checkAccount();
        } else if (id == null || !profile.getRepository().isLoaded() || !profile.getRepository().hasVersion(id)) {
            Controllers.dialog(I18n.i18n("version.empty.launch"), I18n.i18n("launch.failed"), MessageDialogPane.MessageType.ERROR, () -> Controllers.getRootPage().getSelectionModel().select((Object)Controllers.getRootPage().getGameTab()));
        } else {
            return true;
        }
        return false;
    }

    public static void modifyGlobalSettings(Profile profile) {
        VersionSettingsPage page = new VersionSettingsPage();
        page.loadVersion(profile, null);
        Controllers.navigate((Node)page);
    }

    public static void modifyGameSettings(Profile profile, String version) {
        Controllers.getVersionPage().setVersion(version, profile);
        Controllers.navigate((Node)Controllers.getVersionPage());
    }
}

