/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumBackgroundImage;
import org.jackhuang.hmcl.setting.EnumCommonDirectory;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.FontComboBox;
import org.jackhuang.hmcl.ui.construct.MultiFileItem;
import org.jackhuang.hmcl.ui.construct.NumberValidator;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.Locales;

public abstract class SettingsView
extends StackPane {
    protected final JFXTextField txtProxyHost;
    protected final JFXTextField txtProxyPort;
    protected final JFXTextField txtProxyUsername;
    protected final JFXPasswordField txtProxyPassword;
    protected final JFXTextField txtFontSize;
    protected final JFXComboBox<Locales.SupportedLocale> cboLanguage;
    protected final JFXComboBox<String> cboDownloadSource;
    protected final FontComboBox cboFont;
    protected final MultiFileItem<EnumCommonDirectory> fileCommonLocation;
    protected final Label lblDisplay;
    protected final Label lblUpdate;
    protected final Label lblUpdateSub;
    protected final Text lblUpdateNote;
    protected final JFXRadioButton chkUpdateStable;
    protected final JFXRadioButton chkUpdateDev;
    protected final JFXButton btnUpdate;
    protected final ScrollPane scroll = new ScrollPane();
    protected final MultiFileItem<EnumBackgroundImage> backgroundItem;
    protected final StackPane themeColorPickerContainer;
    protected final JFXCheckBox chkDisableProxy;
    protected final JFXRadioButton chkProxyHttp;
    protected final JFXRadioButton chkProxySocks;
    protected final JFXCheckBox chkProxyAuthentication;
    protected final GridPane authPane;
    protected final Pane proxyPane;

    public SettingsView() {
        this.getChildren().setAll((Object[])new Node[]{this.scroll});
        this.scroll.setStyle("-fx-font-size: 14;");
        this.scroll.setFitToWidth(true);
        VBox rootPane = new VBox();
        rootPane.setPadding(new Insets(32.0, 10.0, 32.0, 10.0));
        ComponentList settingsPane = new ComponentList();
        StackPane sponsorPane = new StackPane();
        sponsorPane.setCursor(Cursor.HAND);
        sponsorPane.setOnMouseClicked(e -> this.onSponsor());
        GridPane gridPane = new GridPane();
        ColumnConstraints col = new ColumnConstraints();
        col.setHgrow(Priority.SOMETIMES);
        col.setMaxWidth(Double.POSITIVE_INFINITY);
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{col});
        RowConstraints row = new RowConstraints();
        row.setMinHeight(Double.NEGATIVE_INFINITY);
        row.setValignment(VPos.TOP);
        row.setVgrow(Priority.SOMETIMES);
        gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row});
        Label label = new Label(I18n.i18n("sponsor.hmcl"));
        label.setWrapText(true);
        label.setTextAlignment(TextAlignment.JUSTIFY);
        GridPane.setRowIndex((Node)label, (Integer)0);
        GridPane.setColumnIndex((Node)label, (Integer)0);
        gridPane.getChildren().add((Object)label);
        sponsorPane.getChildren().setAll((Object[])new Node[]{gridPane});
        settingsPane.getContent().add((Object)sponsorPane);
        ComponentSublist updatePane = new ComponentSublist();
        updatePane.setTitle(I18n.i18n("update"));
        updatePane.setHasSubtitle(true);
        VBox headerLeft = new VBox();
        this.lblUpdate = new Label(I18n.i18n("update"));
        this.lblUpdateSub = new Label();
        this.lblUpdateSub.getStyleClass().add((Object)"subtitle-label");
        headerLeft.getChildren().setAll((Object[])new Node[]{this.lblUpdate, this.lblUpdateSub});
        updatePane.setHeaderLeft((Node)headerLeft);
        this.btnUpdate = new JFXButton();
        this.btnUpdate.setOnMouseClicked(e -> this.onUpdate());
        this.btnUpdate.getStyleClass().add((Object)"toggle-icon4");
        this.btnUpdate.setGraphic(SVG.update(Theme.blackFillBinding(), 20.0, 20.0));
        updatePane.setHeaderRight((Node)this.btnUpdate);
        VBox content = new VBox();
        content.setSpacing(8.0);
        this.chkUpdateStable = new JFXRadioButton(I18n.i18n("update.channel.stable"));
        this.chkUpdateDev = new JFXRadioButton(I18n.i18n("update.channel.dev"));
        VBox noteWrapper = new VBox();
        noteWrapper.setStyle("-fx-padding: 10 0 0 0;");
        this.lblUpdateNote = new Text(I18n.i18n("update.note"));
        noteWrapper.getChildren().setAll((Object[])new Node[]{this.lblUpdateNote});
        content.getChildren().setAll((Object[])new Node[]{this.chkUpdateStable, this.chkUpdateDev, noteWrapper});
        updatePane.getContent().add((Object)content);
        settingsPane.getContent().add((Object)updatePane);
        BorderPane docPane = new BorderPane();
        headerLeft = new VBox();
        Label help = new Label(I18n.i18n("help"));
        Label helpSubtitle = new Label(I18n.i18n("help.detail"));
        helpSubtitle.getStyleClass().add((Object)"subtitle-label");
        headerLeft.getChildren().setAll((Object[])new Node[]{help, helpSubtitle});
        docPane.setLeft((Node)headerLeft);
        JFXButton btnExternal = new JFXButton();
        btnExternal.setOnMouseClicked(e -> this.onHelp());
        btnExternal.getStyleClass().add((Object)"toggle-icon4");
        btnExternal.setGraphic(SVG.openInNew(Theme.blackFillBinding(), -1.0, -1.0));
        docPane.setRight((Node)btnExternal);
        settingsPane.getContent().add((Object)docPane);
        this.fileCommonLocation = new MultiFileItem(true);
        this.fileCommonLocation.setTitle(I18n.i18n("launcher.cache_directory"));
        this.fileCommonLocation.setDirectory(true);
        this.fileCommonLocation.setChooserTitle(I18n.i18n("launcher.cache_directory.choose"));
        this.fileCommonLocation.setHasSubtitle(true);
        this.fileCommonLocation.setCustomText("settings.custom");
        JFXButton cleanButton = new JFXButton(I18n.i18n("launcher.cache_directory.clean"));
        cleanButton.setOnMouseClicked(e -> this.clearCacheDirectory());
        cleanButton.getStyleClass().add((Object)"jfx-button-border");
        this.fileCommonLocation.setHeaderRight((Node)cleanButton);
        settingsPane.getContent().add(this.fileCommonLocation);
        this.backgroundItem = new MultiFileItem(true);
        this.backgroundItem.setTitle(I18n.i18n("launcher.background"));
        this.backgroundItem.setChooserTitle(I18n.i18n("launcher.background.choose"));
        this.backgroundItem.setHasSubtitle(true);
        this.backgroundItem.setCustomText(I18n.i18n("settings.custom"));
        settingsPane.getContent().add(this.backgroundItem);
        BorderPane downloadSourcePane = new BorderPane();
        Label label2 = new Label(I18n.i18n("settings.launcher.download_source"));
        BorderPane.setAlignment((Node)label2, (Pos)Pos.CENTER_LEFT);
        downloadSourcePane.setLeft((Node)label2);
        this.cboDownloadSource = new JFXComboBox();
        this.cboDownloadSource.setConverter(FXUtils.stringConverter(key -> I18n.i18n("download.provider." + key)));
        downloadSourcePane.setRight(this.cboDownloadSource);
        settingsPane.getContent().add((Object)downloadSourcePane);
        BorderPane languagePane = new BorderPane();
        Label left = new Label(I18n.i18n("settings.launcher.language"));
        BorderPane.setAlignment((Node)left, (Pos)Pos.CENTER_LEFT);
        languagePane.setLeft((Node)left);
        this.cboLanguage = new JFXComboBox();
        this.cboLanguage.setConverter(FXUtils.stringConverter(locale -> locale.getName(ConfigHolder.config().getLocalization().getResourceBundle())));
        FXUtils.setLimitWidth(this.cboLanguage, 400.0);
        languagePane.setRight(this.cboLanguage);
        settingsPane.getContent().add((Object)languagePane);
        ComponentList proxyList = new ComponentList();
        proxyList.setTitle(I18n.i18n("settings.launcher.proxy"));
        VBox proxyWrapper = new VBox();
        proxyWrapper.setSpacing(10.0);
        this.chkDisableProxy = new JFXCheckBox(I18n.i18n("settings.launcher.proxy.disable"));
        proxyWrapper.getChildren().add((Object)this.chkDisableProxy);
        this.proxyPane = new VBox();
        this.proxyPane.setStyle("-fx-padding: 0 0 0 30;");
        ColumnConstraints colHgrow = new ColumnConstraints();
        colHgrow.setHgrow(Priority.ALWAYS);
        HBox hBox = new HBox();
        this.chkProxyHttp = new JFXRadioButton(I18n.i18n("settings.launcher.proxy.http"));
        this.chkProxySocks = new JFXRadioButton(I18n.i18n("settings.launcher.proxy.socks"));
        hBox.getChildren().setAll((Object[])new Node[]{this.chkProxyHttp, this.chkProxySocks});
        this.proxyPane.getChildren().add((Object)hBox);
        GridPane gridPane2 = new GridPane();
        gridPane2.setHgap(20.0);
        gridPane2.setVgap(10.0);
        gridPane2.setStyle("-fx-padding: 0 0 0 15;");
        gridPane2.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), colHgrow});
        gridPane2.getRowConstraints().setAll((Object[])new RowConstraints[]{new RowConstraints(), new RowConstraints()});
        Label host = new Label(I18n.i18n("settings.launcher.proxy.host"));
        GridPane.setRowIndex((Node)host, (Integer)1);
        GridPane.setColumnIndex((Node)host, (Integer)0);
        GridPane.setHalignment((Node)host, (HPos)HPos.RIGHT);
        gridPane2.getChildren().add((Object)host);
        this.txtProxyHost = new JFXTextField();
        GridPane.setRowIndex((Node)this.txtProxyHost, (Integer)1);
        GridPane.setColumnIndex((Node)this.txtProxyHost, (Integer)1);
        gridPane2.getChildren().add((Object)this.txtProxyHost);
        Label port = new Label(I18n.i18n("settings.launcher.proxy.port"));
        GridPane.setRowIndex((Node)port, (Integer)2);
        GridPane.setColumnIndex((Node)port, (Integer)0);
        GridPane.setHalignment((Node)port, (HPos)HPos.RIGHT);
        gridPane2.getChildren().add((Object)port);
        this.txtProxyPort = new JFXTextField();
        GridPane.setRowIndex((Node)this.txtProxyPort, (Integer)2);
        GridPane.setColumnIndex((Node)this.txtProxyPort, (Integer)1);
        FXUtils.setValidateWhileTextChanged((Node)this.txtProxyPort, true);
        this.txtProxyHost.getValidators().setAll((Object[])new ValidatorBase[]{new NumberValidator(I18n.i18n("input.number"), false)});
        gridPane2.getChildren().add((Object)this.txtProxyPort);
        this.proxyPane.getChildren().add((Object)gridPane2);
        VBox vBox = new VBox();
        vBox.setStyle("-fx-padding: 20 0 20 5;");
        this.chkProxyAuthentication = new JFXCheckBox(I18n.i18n("settings.launcher.proxy.authentication"));
        vBox.getChildren().setAll((Object[])new Node[]{this.chkProxyAuthentication});
        this.proxyPane.getChildren().add((Object)vBox);
        this.authPane = new GridPane();
        this.authPane.setHgap(20.0);
        this.authPane.setVgap(10.0);
        this.authPane.setStyle("-fx-padding: 0 0 0 15;");
        this.authPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{new ColumnConstraints(), colHgrow});
        this.authPane.getRowConstraints().setAll((Object[])new RowConstraints[]{new RowConstraints(), new RowConstraints()});
        Label username = new Label(I18n.i18n("settings.launcher.proxy.username"));
        GridPane.setRowIndex((Node)username, (Integer)0);
        GridPane.setColumnIndex((Node)username, (Integer)0);
        this.authPane.getChildren().add((Object)username);
        this.txtProxyUsername = new JFXTextField();
        GridPane.setRowIndex((Node)this.txtProxyUsername, (Integer)0);
        GridPane.setColumnIndex((Node)this.txtProxyUsername, (Integer)1);
        this.authPane.getChildren().add((Object)this.txtProxyUsername);
        Label password = new Label(I18n.i18n("settings.launcher.proxy.password"));
        GridPane.setRowIndex((Node)password, (Integer)1);
        GridPane.setColumnIndex((Node)password, (Integer)0);
        this.authPane.getChildren().add((Object)password);
        this.txtProxyPassword = new JFXPasswordField();
        GridPane.setRowIndex((Node)this.txtProxyPassword, (Integer)1);
        GridPane.setColumnIndex((Node)this.txtProxyPassword, (Integer)1);
        this.authPane.getChildren().add((Object)this.txtProxyPassword);
        this.proxyPane.getChildren().add((Object)this.authPane);
        proxyWrapper.getChildren().add((Object)this.proxyPane);
        proxyList.getContent().add((Object)proxyWrapper);
        settingsPane.getContent().add((Object)proxyList);
        BorderPane themePane = new BorderPane();
        left = new Label(I18n.i18n("settings.launcher.theme"));
        BorderPane.setAlignment((Node)left, (Pos)Pos.CENTER_LEFT);
        themePane.setLeft((Node)left);
        this.themeColorPickerContainer = new StackPane();
        this.themeColorPickerContainer.setMinHeight(30.0);
        themePane.setRight((Node)this.themeColorPickerContainer);
        settingsPane.getContent().add((Object)themePane);
        ComponentSublist logPane = new ComponentSublist();
        logPane.setTitle(I18n.i18n("settings.launcher.log"));
        JFXButton logButton = new JFXButton(I18n.i18n("settings.launcher.launcher_log.export"));
        logButton.setOnMouseClicked(e -> this.onExportLogs());
        logButton.getStyleClass().add((Object)"jfx-button-border");
        logPane.setHeaderRight((Node)logButton);
        VBox fontPane = new VBox();
        fontPane.setSpacing(5.0);
        BorderPane borderPane = new BorderPane();
        fontPane.getChildren().add((Object)borderPane);
        Label left2 = new Label(I18n.i18n("settings.launcher.log.font"));
        BorderPane.setAlignment((Node)left2, (Pos)Pos.CENTER_LEFT);
        borderPane.setLeft((Node)left2);
        hBox = new HBox();
        hBox.setSpacing(3.0);
        this.cboFont = new FontComboBox(12.0);
        this.txtFontSize = new JFXTextField();
        FXUtils.setLimitWidth((Region)this.txtFontSize, 50.0);
        hBox.getChildren().setAll((Object[])new Node[]{this.cboFont, this.txtFontSize});
        borderPane.setRight((Node)hBox);
        this.lblDisplay = new Label("[23:33:33] [Client Thread/INFO] [WaterPower]: Loaded mod WaterPower.");
        fontPane.getChildren().add((Object)this.lblDisplay);
        logPane.getContent().add((Object)fontPane);
        settingsPane.getContent().add((Object)logPane);
        StackPane aboutPane = new StackPane();
        gridPane = new GridPane();
        gridPane.setHgap(20.0);
        gridPane.setVgap(10.0);
        ColumnConstraints col1 = new ColumnConstraints();
        col1.setHgrow(Priority.SOMETIMES);
        col1.setMaxWidth(Double.NEGATIVE_INFINITY);
        col1.setMinWidth(Double.NEGATIVE_INFINITY);
        ColumnConstraints col2 = new ColumnConstraints();
        col2.setHgrow(Priority.SOMETIMES);
        col2.setMinWidth(20.0);
        col2.setMaxWidth(Double.POSITIVE_INFINITY);
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{col1, col2});
        RowConstraints row2 = new RowConstraints();
        row2.setMinHeight(Double.NEGATIVE_INFINITY);
        row2.setValignment(VPos.TOP);
        row2.setVgrow(Priority.SOMETIMES);
        gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row2, row2, row2, row2, row2, row2});
        Label label3 = new Label(I18n.i18n("about.copyright"));
        GridPane.setRowIndex((Node)label3, (Integer)0);
        GridPane.setColumnIndex((Node)label3, (Integer)0);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.copyright.statement"));
        label3.setWrapText(true);
        GridPane.setRowIndex((Node)label3, (Integer)0);
        GridPane.setColumnIndex((Node)label3, (Integer)1);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.author"));
        GridPane.setRowIndex((Node)label3, (Integer)1);
        GridPane.setColumnIndex((Node)label3, (Integer)0);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.author.statement"));
        label3.setWrapText(true);
        GridPane.setRowIndex((Node)label3, (Integer)1);
        GridPane.setColumnIndex((Node)label3, (Integer)1);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.thanks_to"));
        GridPane.setRowIndex((Node)label3, (Integer)2);
        GridPane.setColumnIndex((Node)label3, (Integer)0);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.thanks_to.statement"));
        label3.setWrapText(true);
        GridPane.setRowIndex((Node)label3, (Integer)2);
        GridPane.setColumnIndex((Node)label3, (Integer)1);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.dependency"));
        GridPane.setRowIndex((Node)label3, (Integer)3);
        GridPane.setColumnIndex((Node)label3, (Integer)0);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.dependency.statement"));
        label3.setWrapText(true);
        GridPane.setRowIndex((Node)label3, (Integer)3);
        GridPane.setColumnIndex((Node)label3, (Integer)1);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.claim"));
        GridPane.setRowIndex((Node)label3, (Integer)4);
        GridPane.setColumnIndex((Node)label3, (Integer)0);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.claim.statement"));
        label3.setWrapText(true);
        label3.setTextAlignment(TextAlignment.JUSTIFY);
        GridPane.setRowIndex((Node)label3, (Integer)4);
        GridPane.setColumnIndex((Node)label3, (Integer)1);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.open_source"));
        GridPane.setRowIndex((Node)label3, (Integer)5);
        GridPane.setColumnIndex((Node)label3, (Integer)0);
        gridPane.getChildren().add((Object)label3);
        label3 = new Label(I18n.i18n("about.open_source.statement"));
        label3.setWrapText(true);
        GridPane.setRowIndex((Node)label3, (Integer)5);
        GridPane.setColumnIndex((Node)label3, (Integer)1);
        gridPane.getChildren().add((Object)label3);
        aboutPane.getChildren().setAll((Object[])new Node[]{gridPane});
        settingsPane.getContent().add((Object)aboutPane);
        rootPane.getChildren().add((Object)settingsPane);
        this.scroll.setContent((Node)rootPane);
    }

    protected abstract void onUpdate();

    protected abstract void onHelp();

    protected abstract void onExportLogs();

    protected abstract void onSponsor();

    protected abstract void clearCacheDirectory();
}

