/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import java.io.File;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.event.RefreshedVersionsEvent;
import org.jackhuang.hmcl.game.HMCLGameRepository;
import org.jackhuang.hmcl.game.ModpackHelper;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.Profile;
import org.jackhuang.hmcl.setting.Profiles;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AccountAdvancedListItem;
import org.jackhuang.hmcl.ui.account.AccountList;
import org.jackhuang.hmcl.ui.account.AddAccountPane;
import org.jackhuang.hmcl.ui.construct.AdvancedListBox;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.ui.construct.TabControl;
import org.jackhuang.hmcl.ui.decorator.DecoratorTabPage;
import org.jackhuang.hmcl.ui.download.ModpackInstallWizardProvider;
import org.jackhuang.hmcl.ui.main.MainPage;
import org.jackhuang.hmcl.ui.main.SettingsPage;
import org.jackhuang.hmcl.ui.profile.ProfileAdvancedListItem;
import org.jackhuang.hmcl.ui.profile.ProfileList;
import org.jackhuang.hmcl.ui.versions.GameAdvancedListItem;
import org.jackhuang.hmcl.ui.versions.GameList;
import org.jackhuang.hmcl.ui.versions.Versions;
import org.jackhuang.hmcl.upgrade.UpdateChecker;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.javafx.BindingMapping;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public class RootPage
extends DecoratorTabPage {
    private MainPage mainPage = null;
    private SettingsPage settingsPage = null;
    private GameList gameListPage = null;
    private AccountList accountListPage = null;
    private ProfileList profileListPage = null;
    private final TabControl.Tab mainTab = new TabControl.Tab("main");
    private final TabControl.Tab settingsTab = new TabControl.Tab("settings");
    private final TabControl.Tab gameTab = new TabControl.Tab("game");
    private final TabControl.Tab accountTab = new TabControl.Tab("account");
    private final TabControl.Tab profileTab = new TabControl.Tab("profile");
    private boolean checkedAccont = false;
    private boolean checkedModpack = false;

    public RootPage() {
        this.setLeftPaneWidth(200.0);
        EventBus.EVENT_BUS.channel(RefreshedVersionsEvent.class).register(event -> this.onRefreshedVersions((HMCLGameRepository)event.getSource()));
        Profile profile = Profiles.getSelectedProfile();
        if (profile != null && profile.getRepository().isLoaded()) {
            this.onRefreshedVersions(((Profile)Profiles.selectedProfileProperty().get()).getRepository());
        }
        this.mainTab.setNodeSupplier(this::getMainPage);
        this.settingsTab.setNodeSupplier(this::getSettingsPage);
        this.gameTab.setNodeSupplier(this::getGameListPage);
        this.accountTab.setNodeSupplier(this::getAccountListPage);
        this.profileTab.setNodeSupplier(this::getProfileListPage);
        this.getTabs().setAll((Object[])new TabControl.Tab[]{this.mainTab, this.settingsTab, this.gameTab, this.accountTab, this.profileTab});
    }

    @Override
    public boolean back() {
        if (this.mainTab.isSelected()) {
            return true;
        }
        this.getSelectionModel().select((Object)this.mainTab);
        return false;
    }

    @Override
    protected void onNavigated(Node to) {
        this.backableProperty().set(!(to instanceof MainPage));
        this.setTitleBarTransparent(to instanceof MainPage);
        super.onNavigated(to);
    }

    protected Skin createDefaultSkin() {
        return new Skin(this);
    }

    private MainPage getMainPage() {
        if (this.mainPage == null) {
            MainPage mainPage = new MainPage();
            FXUtils.applyDragListener((Node)mainPage, it -> "zip".equals(FileUtils.getExtension(it)), modpacks -> {
                File modpack = (File)modpacks.get(0);
                Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(Profiles.getSelectedProfile(), modpack), I18n.i18n("install.modpack"));
            });
            FXUtils.onChangeAndOperate(Profiles.selectedVersionProperty(), mainPage::setCurrentGame);
            mainPage.showUpdateProperty().bind((ObservableValue)UpdateChecker.outdatedProperty());
            mainPage.latestVersionProperty().bind(BindingMapping.of(UpdateChecker.latestVersionProperty()).map(version -> version == null ? "" : I18n.i18n("update.bubble.title", version.getVersion())));
            Profiles.registerVersionsListener(profile -> {
                HMCLGameRepository repository = profile.getRepository();
                List children = repository.getVersions().parallelStream().filter(version -> !version.isHidden()).sorted(Comparator.comparing(version -> version.getReleaseTime() == null ? new Date(0L) : version.getReleaseTime()).thenComparing(a -> VersionNumber.asVersion(a.getId()))).collect(Collectors.toList());
                FXUtils.runInFX(() -> {
                    if (profile == Profiles.getSelectedProfile()) {
                        mainPage.initVersions((Profile)profile, children);
                    }
                });
            });
            this.mainPage = mainPage;
        }
        return this.mainPage;
    }

    private SettingsPage getSettingsPage() {
        if (this.settingsPage == null) {
            this.settingsPage = new SettingsPage();
        }
        return this.settingsPage;
    }

    private GameList getGameListPage() {
        if (this.gameListPage == null) {
            this.gameListPage = new GameList();
            FXUtils.applyDragListener((Node)this.gameListPage, it -> "zip".equals(FileUtils.getExtension(it)), modpacks -> {
                File modpack = (File)modpacks.get(0);
                Controllers.getDecorator().startWizard(new ModpackInstallWizardProvider(Profiles.getSelectedProfile(), modpack), I18n.i18n("install.modpack"));
            });
        }
        return this.gameListPage;
    }

    private AccountList getAccountListPage() {
        if (this.accountListPage == null) {
            this.accountListPage = new AccountList();
            this.accountListPage.selectedAccountProperty().bindBidirectional(Accounts.selectedAccountProperty());
            this.accountListPage.accountsProperty().bindContent(Accounts.accountsProperty());
        }
        return this.accountListPage;
    }

    private ProfileList getProfileListPage() {
        if (this.profileListPage == null) {
            this.profileListPage = new ProfileList();
            this.profileListPage.selectedProfileProperty().bindBidirectional(Profiles.selectedProfileProperty());
            this.profileListPage.profilesProperty().bindContent(Profiles.profilesProperty());
        }
        return this.profileListPage;
    }

    public TabControl.Tab getMainTab() {
        return this.mainTab;
    }

    public TabControl.Tab getSettingsTab() {
        return this.settingsTab;
    }

    public TabControl.Tab getGameTab() {
        return this.gameTab;
    }

    public TabControl.Tab getAccountTab() {
        return this.accountTab;
    }

    public TabControl.Tab getProfileTab() {
        return this.profileTab;
    }

    private void selectPage(TabControl.Tab tab) {
        if (this.getSelectionModel().getSelectedItem() == tab) {
            this.getSelectionModel().select((Object)this.getMainTab());
        } else {
            this.getSelectionModel().select((Object)tab);
        }
    }

    public void checkAccount() {
        if (this.checkedAccont) {
            return;
        }
        this.checkedAccont = true;
        if (Accounts.getAccounts().isEmpty()) {
            Platform.runLater(this::addNewAccount);
        }
    }

    private void addNewAccount() {
        Controllers.dialog((Region)new AddAccountPane());
    }

    private void onRefreshedVersions(HMCLGameRepository repository) {
        FXUtils.runInFX(() -> {
            if (!this.checkedModpack) {
                File modpackFile;
                this.checkedModpack = true;
                if (repository.getVersionCount() == 0 && (modpackFile = new File("modpack.zip").getAbsoluteFile()).exists()) {
                    Task.supplyAsync(() -> CompressingUtils.findSuitableEncoding(modpackFile.toPath())).thenApplyAsync(encoding -> ModpackHelper.readModpackManifest(modpackFile.toPath(), encoding)).thenApplyAsync(modpack -> ModpackHelper.getInstallTask(repository.getProfile(), modpackFile, modpack.getName(), modpack).withRunAsync(Schedulers.javafx(), this::checkAccount).executor()).thenAcceptAsync(Schedulers.javafx(), executor -> {
                        Controllers.taskDialog(executor, I18n.i18n("modpack.installing"));
                        executor.start();
                    }).start();
                }
            }
            this.checkAccount();
        });
    }

    private static class Skin
    extends SkinBase<RootPage> {
        protected Skin(RootPage control) {
            super((Control)control);
            AccountAdvancedListItem accountListItem = new AccountAdvancedListItem();
            accountListItem.activeProperty().bind((ObservableValue)control.accountTab.selectedProperty());
            accountListItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.selectPage(control.accountTab)));
            accountListItem.accountProperty().bind(Accounts.selectedAccountProperty());
            GameAdvancedListItem gameListItem = new GameAdvancedListItem();
            gameListItem.actionButtonVisibleProperty().bind((ObservableValue)Profiles.selectedVersionProperty().isNotNull());
            gameListItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> {
                Profile profile = Profiles.getSelectedProfile();
                String version = Profiles.getSelectedVersion();
                if (version == null) {
                    control.selectPage(control.gameTab);
                } else {
                    Versions.modifyGameSettings(profile, version);
                }
            }));
            AdvancedListItem gameItem = new AdvancedListItem();
            gameItem.activeProperty().bind((ObservableValue)control.gameTab.selectedProperty());
            gameItem.setImage(FXUtils.newImage("/assets/img/bookshelf.png"));
            gameItem.setTitle(I18n.i18n("version.manage"));
            gameItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.selectPage(control.gameTab)));
            ProfileAdvancedListItem profileListItem = new ProfileAdvancedListItem();
            profileListItem.activeProperty().bind((ObservableValue)control.profileTab.selectedProperty());
            profileListItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.selectPage(control.profileTab)));
            profileListItem.profileProperty().bind(Profiles.selectedProfileProperty());
            AdvancedListItem launcherSettingsItem = new AdvancedListItem();
            launcherSettingsItem.activeProperty().bind((ObservableValue)control.settingsTab.selectedProperty());
            launcherSettingsItem.setImage(FXUtils.newImage("/assets/img/command.png"));
            launcherSettingsItem.setTitle(I18n.i18n("settings.launcher"));
            launcherSettingsItem.setOnAction((EventHandler<ActionEvent>)((EventHandler)e -> control.selectPage(control.settingsTab)));
            AdvancedListBox sideBar = new AdvancedListBox().startCategory(I18n.i18n("account").toUpperCase()).add((Node)accountListItem).startCategory(I18n.i18n("version").toUpperCase()).add((Node)gameListItem).add((Node)gameItem).startCategory(I18n.i18n("profile.title").toUpperCase()).add((Node)profileListItem).startCategory(I18n.i18n("launcher").toUpperCase()).add((Node)launcherSettingsItem);
            BorderPane root = new BorderPane();
            sideBar.setPrefWidth(200.0);
            root.setLeft((Node)sideBar);
            control.transitionPane.getStyleClass().add((Object)"jfx-decorator-content-container");
            control.transitionPane.getChildren().setAll((Object[])new Node[]{((RootPage)this.getSkinnable()).getMainPage()});
            FXUtils.setOverflowHidden((Region)control.transitionPane, 8.0);
            root.setCenter((Node)control.transitionPane);
            this.getChildren().setAll((Object[])new Node[]{root});
        }
    }
}

