/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.download;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.effects.JFXDepthManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.wizard.WizardController;
import org.jackhuang.hmcl.ui.wizard.WizardPage;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class ModpackSelectionPage
extends StackPane
implements WizardPage {
    private final WizardController controller;
    @FXML
    private JFXButton btnLocal;
    @FXML
    private JFXButton btnRemote;

    public ModpackSelectionPage(WizardController controller) {
        this.controller = controller;
        FXUtils.loadFXML((Node)this, "/assets/fxml/download/modpack-source.fxml");
        JFXDepthManager.setDepth((Node)this.btnLocal, 1);
        JFXDepthManager.setDepth((Node)this.btnRemote, 1);
        Optional<File> filePath = Lang.tryCast(controller.getSettings().get("MODPACK_FILE"), File.class);
        if (filePath.isPresent()) {
            controller.getSettings().put("MODPACK_FILE", filePath.get());
            Platform.runLater(controller::onNext);
        }
        FXUtils.applyDragListener((Node)this, it -> "zip".equals(FileUtils.getExtension(it)), modpacks -> {
            File modpack = (File)modpacks.get(0);
            controller.getSettings().put("MODPACK_FILE", modpack);
            controller.onNext();
        });
    }

    @FXML
    private void onChooseLocalFile() {
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("modpack.choose"));
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("modpack"), new String[]{"*.zip"}));
        File selectedFile = chooser.showOpenDialog((Window)Controllers.getStage());
        if (selectedFile == null) {
            Platform.runLater(this.controller::onEnd);
            return;
        }
        this.controller.getSettings().put("MODPACK_FILE", selectedFile);
        this.controller.onNext();
    }

    @FXML
    private void onChooseRemoteFile() {
        Controllers.prompt(I18n.i18n("modpack.choose.remote.tooltip"), (urlString, resolve, reject) -> {
            try {
                URL url = new URL((String)urlString);
                if (urlString.endsWith("server-manifest.json")) {
                    Controllers.taskDialog(new GetTask(url).whenComplete(Schedulers.javafx(), (result, e) -> {
                        ServerModpackManifest manifest = JsonUtils.fromMaybeMalformedJson(result, ServerModpackManifest.class);
                        if (manifest == null) {
                            reject.accept(I18n.i18n("modpack.type.server.malformed"));
                        } else if (e == null) {
                            resolve.run();
                            this.controller.getSettings().put("MODPACK_SERVER_MANIFEST", manifest);
                            this.controller.onNext();
                        } else {
                            reject.accept(e.getMessage());
                        }
                    }).executor(true), I18n.i18n("message.downloading"));
                } else {
                    Path modpack = Files.createTempFile("modpack", ".zip", new FileAttribute[0]);
                    resolve.run();
                    Controllers.taskDialog(new FileDownloadTask(url, modpack.toFile(), null).whenComplete(Schedulers.javafx(), e -> {
                        if (e == null) {
                            resolve.run();
                            this.controller.getSettings().put("MODPACK_FILE", modpack.toFile());
                            this.controller.onNext();
                        } else {
                            reject.accept(e.getMessage());
                        }
                    }).executor(true), I18n.i18n("message.downloading"));
                }
            }
            catch (IOException e2) {
                reject.accept(e2.getMessage());
            }
        });
    }

    @Override
    public void cleanup(Map<String, Object> settings) {
    }

    @Override
    public String getTitle() {
        return I18n.i18n("modpack.task.install");
    }
}

