/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.decorator;

import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.scene.Node;
import org.jackhuang.hmcl.ui.construct.Navigator;
import org.jackhuang.hmcl.ui.wizard.Refreshable;

public interface DecoratorPage
extends Refreshable {
    public ReadOnlyObjectProperty<State> stateProperty();

    default public boolean isPageCloseable() {
        return false;
    }

    default public boolean back() {
        return true;
    }

    @Override
    default public void refresh() {
    }

    default public void closePage() {
    }

    default public void onDecoratorPageNavigating(Navigator.NavigationEvent event) {
        ((Node)this).getStyleClass().add((Object)"content-background");
    }

    public static class State {
        private final String title;
        private final Node titleNode;
        private final boolean backable;
        private final boolean refreshable;
        private final boolean animate;
        private final boolean titleBarTransparent;
        private final double leftPaneWidth;

        public State(String title, Node titleNode, boolean backable, boolean refreshable, boolean animate) {
            this(title, titleNode, backable, refreshable, animate, false, 0.0);
        }

        public State(String title, Node titleNode, boolean backable, boolean refreshable, boolean animate, boolean titleBarTransparent, double leftPaneWidth) {
            this.title = title;
            this.titleNode = titleNode;
            this.backable = backable;
            this.refreshable = refreshable;
            this.animate = animate;
            this.titleBarTransparent = titleBarTransparent;
            this.leftPaneWidth = leftPaneWidth;
        }

        public static State fromTitle(String title) {
            return new State(title, null, true, false, true);
        }

        public static State fromTitleNode(Node titleNode) {
            return new State(null, titleNode, true, false, true);
        }

        public String getTitle() {
            return this.title;
        }

        public Node getTitleNode() {
            return this.titleNode;
        }

        public boolean isBackable() {
            return this.backable;
        }

        public boolean isRefreshable() {
            return this.refreshable;
        }

        public boolean isAnimate() {
            return this.animate;
        }

        public boolean isTitleBarTransparent() {
            return this.titleBarTransparent;
        }

        public double getLeftPaneWidth() {
            return this.leftPaneWidth;
        }
    }
}

