/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.util.StringUtils;

public class TwoLineListItem
extends VBox {
    private static final String DEFAULT_STYLE_CLASS = "two-line-list-item";
    private final StringProperty title = new SimpleStringProperty((Object)this, "title");
    private final StringProperty tag = new SimpleStringProperty((Object)this, "tag");
    private final StringProperty subtitle = new SimpleStringProperty((Object)this, "subtitle");

    public TwoLineListItem(String titleString, String subtitleString) {
        this();
        this.title.set((Object)titleString);
        this.subtitle.set((Object)subtitleString);
    }

    public TwoLineListItem() {
        this.setMouseTransparent(true);
        HBox firstLine = new HBox();
        Label lblTitle = new Label();
        lblTitle.getStyleClass().add((Object)"title");
        lblTitle.textProperty().bind((ObservableValue)this.title);
        Label lblTag = new Label();
        lblTag.getStyleClass().add((Object)"tag");
        lblTag.textProperty().bind((ObservableValue)this.tag);
        lblTag.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> StringUtils.isNotBlank(this.tag.getValue()), (Observable[])new Observable[]{this.tag}));
        firstLine.getChildren().addAll((Object[])new Node[]{lblTitle, lblTag});
        Label lblSubtitle = new Label();
        lblSubtitle.getStyleClass().add((Object)"subtitle");
        lblSubtitle.textProperty().bind((ObservableValue)this.subtitle);
        this.getChildren().setAll((Object[])new Node[]{firstLine, lblSubtitle});
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public String getTag() {
        return (String)this.tag.get();
    }

    public StringProperty tagProperty() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag.set((Object)tag);
    }

    public String toString() {
        return this.getTitle();
    }
}

