/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXSpinner;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.DefaultProperty;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.animation.AnimationHandler;
import org.jackhuang.hmcl.ui.animation.AnimationProducer;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;

@DefaultProperty(value="content")
public class SpinnerPane
extends Control {
    private final ObjectProperty<Node> content = new SimpleObjectProperty((Object)this, "content");
    private final BooleanProperty loading = new SimpleBooleanProperty((Object)this, "loading");

    public void showSpinner() {
        this.setLoading(true);
    }

    public void hideSpinner() {
        this.setLoading(false);
    }

    public Node getContent() {
        return (Node)this.content.get();
    }

    public ObjectProperty<Node> contentProperty() {
        return this.content;
    }

    public void setContent(Node content) {
        this.content.set((Object)content);
    }

    public boolean isLoading() {
        return this.loading.get();
    }

    public BooleanProperty loadingProperty() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading.set(loading);
    }

    protected Skin createDefaultSkin() {
        return new Skin(this);
    }

    private static class Skin
    extends SkinBase<SpinnerPane> {
        private final JFXSpinner spinner = new JFXSpinner();
        private final StackPane contentPane = new StackPane();
        private final StackPane topPane = new StackPane();
        private final StackPane root = new StackPane();
        private Timeline animation;

        protected Skin(SpinnerPane control) {
            super((Control)control);
            this.root.getStyleClass().add((Object)"spinner-pane");
            this.topPane.getChildren().setAll((Object[])new Node[]{this.spinner});
            this.root.getChildren().setAll((Object[])new Node[]{this.contentPane, this.topPane});
            FXUtils.onChangeAndOperate(((SpinnerPane)this.getSkinnable()).content, newValue -> this.contentPane.getChildren().setAll((Object[])new Node[]{newValue}));
            this.getChildren().setAll((Object[])new Node[]{this.root});
            FXUtils.onChangeAndOperate(((SpinnerPane)this.getSkinnable()).loadingProperty(), newValue -> {
                Timeline prev = this.animation;
                if (prev != null) {
                    prev.stop();
                }
                this.topPane.setMouseTransparent(true);
                this.topPane.setVisible(true);
                this.topPane.getStyleClass().add((Object)"gray-background");
                AnimationProducer transition = newValue != false ? ContainerAnimations.FADE_IN.getAnimationProducer() : ContainerAnimations.FADE_OUT.getAnimationProducer();
                AnimationHandler handler = new AnimationHandler(){

                    @Override
                    public Duration getDuration() {
                        return Duration.millis((double)160.0);
                    }

                    @Override
                    public Pane getCurrentRoot() {
                        return root;
                    }

                    @Override
                    public Node getPreviousNode() {
                        return null;
                    }

                    @Override
                    public Node getCurrentNode() {
                        return topPane;
                    }
                };
                Timeline now = new Timeline();
                now.getKeyFrames().addAll(transition.animate(handler));
                now.getKeyFrames().add((Object)new KeyFrame(handler.getDuration(), e -> {
                    this.topPane.setMouseTransparent(newValue == false);
                    this.topPane.setVisible(newValue.booleanValue());
                }, new KeyValue[0]));
                now.play();
                this.animation = now;
            });
        }
    }
}

