/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.validation.base.ValidatorBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.util.FutureCallback;
import org.jackhuang.hmcl.util.StringUtils;

public class PromptDialogPane
extends StackPane {
    private final CompletableFuture<List<Builder.Question<?>>> future = new CompletableFuture();
    @FXML
    private JFXButton acceptButton;
    @FXML
    private JFXButton cancelButton;
    @FXML
    private VBox vbox;
    @FXML
    private Label title;
    @FXML
    private Label lblCreationWarning;
    @FXML
    private SpinnerPane acceptPane;

    public PromptDialogPane(Builder builder) {
        FXUtils.loadFXML((Node)this, "/assets/fxml/input-dialog.fxml");
        this.title.setText(builder.title);
        ArrayList<BooleanBinding> bindings = new ArrayList<BooleanBinding>();
        for (Builder.Question question : builder.questions) {
            HBox hBox;
            if (question instanceof Builder.StringQuestion) {
                JFXTextField textField = new JFXTextField();
                textField.textProperty().addListener((a, b, newValue) -> {
                    ((Builder.StringQuestion)question).value = textField.getText();
                    Object cfr_ignored_0 = ((Builder.StringQuestion)question).value;
                });
                textField.setText((String)((Builder.StringQuestion)question).value);
                textField.setValidators(((Builder.StringQuestion)question).validators.toArray(new ValidatorBase[0]));
                bindings.add(Bindings.createBooleanBinding(textField::validate, (Observable[])new Observable[]{textField.textProperty()}));
                if (StringUtils.isNotBlank(question.question)) {
                    this.vbox.getChildren().add((Object)new Label(question.question));
                }
                VBox.setMargin((Node)textField, (Insets)new Insets(0.0, 0.0, 20.0, 0.0));
                this.vbox.getChildren().add((Object)textField);
                continue;
            }
            if (question instanceof Builder.BooleanQuestion) {
                hBox = new HBox();
                JFXCheckBox checkBox = new JFXCheckBox();
                hBox.getChildren().setAll((Object[])new Node[]{checkBox});
                HBox.setMargin((Node)checkBox, (Insets)new Insets(0.0, 0.0, 0.0, -10.0));
                checkBox.setSelected((Boolean)((Builder.BooleanQuestion)question).value);
                checkBox.selectedProperty().addListener((a, b, newValue) -> {
                    ((Builder.BooleanQuestion)question).value = newValue;
                    Object cfr_ignored_0 = ((Builder.BooleanQuestion)question).value;
                });
                checkBox.setText(question.question);
                this.vbox.getChildren().add((Object)hBox);
                continue;
            }
            if (!(question instanceof Builder.CandidatesQuestion)) continue;
            hBox = new HBox();
            JFXComboBox comboBox = new JFXComboBox();
            hBox.getChildren().setAll((Object[])new Node[]{comboBox});
            comboBox.getItems().setAll(((Builder.CandidatesQuestion)question).candidates);
            comboBox.getSelectionModel().selectedIndexProperty().addListener((a, b, newValue) -> {
                ((Builder.CandidatesQuestion)question).value = newValue.intValue();
                Object cfr_ignored_0 = ((Builder.CandidatesQuestion)question).value;
            });
            comboBox.getSelectionModel().select(0);
            if (StringUtils.isNotBlank(question.question)) {
                this.vbox.getChildren().add((Object)new Label(question.question));
            }
            this.vbox.getChildren().add((Object)hBox);
        }
        this.cancelButton.setOnMouseClicked(e -> this.fireEvent(new DialogCloseEvent()));
        this.acceptButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> bindings.stream().map(BooleanBinding::get).anyMatch(x -> x == false), (Observable[])((Observable[])bindings.toArray(new BooleanBinding[0]))));
        this.acceptButton.setOnMouseClicked(e -> {
            this.acceptPane.showSpinner();
            builder.callback.call(builder.questions, () -> {
                this.acceptPane.hideSpinner();
                this.future.complete(builder.questions);
                this.fireEvent(new DialogCloseEvent());
            }, msg -> {
                this.acceptPane.hideSpinner();
                this.lblCreationWarning.setText(msg);
            });
        });
    }

    public CompletableFuture<List<Builder.Question<?>>> getCompletableFuture() {
        return this.future;
    }

    public static class Builder {
        private final List<Question<?>> questions = new ArrayList();
        private final String title;
        private final FutureCallback<List<Question<?>>> callback;

        public Builder(String title, FutureCallback<List<Question<?>>> callback) {
            this.title = title;
            this.callback = callback;
        }

        public <T> Builder addQuestion(Question<T> question) {
            this.questions.add(question);
            return this;
        }

        public static class BooleanQuestion
        extends Question<Boolean> {
            public BooleanQuestion(String question, boolean defaultValue) {
                super(question);
                this.value = defaultValue;
            }
        }

        public static class CandidatesQuestion
        extends Question<Integer> {
            protected final List<String> candidates;

            public CandidatesQuestion(String question, String ... candidates) {
                super(question);
                this.value = null;
                if (candidates == null || candidates.length == 0) {
                    throw new IllegalArgumentException("At least one candidate required");
                }
                this.candidates = new ArrayList<String>(Arrays.asList(candidates));
            }
        }

        public static class Question<T> {
            public final String question;
            protected T value;

            public Question(String question) {
                this.question = question;
            }

            public T getValue() {
                return this.value;
            }
        }

        public static class StringQuestion
        extends Question<String> {
            protected final List<ValidatorBase> validators;

            public StringQuestion(String question, String defaultValue, ValidatorBase ... validators) {
                super(question);
                this.value = defaultValue;
                this.validators = Arrays.asList(validators);
            }
        }
    }
}

