/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXRadioButton;
import com.jfoenix.controls.JFXTextField;
import java.io.File;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.util.i18n.I18n;

public class MultiFileItem<T>
extends ComponentSublist {
    private final StringProperty customTitle = new SimpleStringProperty((Object)this, "customTitle", I18n.i18n("selector.custom"));
    private final StringProperty chooserTitle = new SimpleStringProperty((Object)this, "chooserTitle", I18n.i18n("selector.choose_file"));
    private final BooleanProperty directory = new SimpleBooleanProperty((Object)this, "directory", false);
    private final ObjectProperty<T> selectedData = new SimpleObjectProperty((Object)this, "selectedData");
    private final ObjectProperty<T> fallbackData = new SimpleObjectProperty((Object)this, "fallbackData");
    private final ObservableList<FileChooser.ExtensionFilter> extensionFilters = FXCollections.observableArrayList();
    private final ToggleGroup group = new ToggleGroup();
    private final JFXTextField txtCustom = new JFXTextField();
    private final JFXButton btnSelect = new JFXButton();
    private final JFXRadioButton radioCustom = new JFXRadioButton();
    private final BorderPane custom = new BorderPane();
    private final VBox pane = new VBox();
    private final boolean hasCustom;
    private Consumer<Toggle> toggleSelectedListener;

    public MultiFileItem(@NamedArg(value="hasCustom", defaultValue="true") boolean hasCustom) {
        this.hasCustom = hasCustom;
        BorderPane.setAlignment((Node)this.txtCustom, (Pos)Pos.CENTER_RIGHT);
        this.btnSelect.setGraphic(SVG.folderOpen(Theme.blackFillBinding(), 15.0, 15.0));
        this.btnSelect.setOnMouseClicked(e -> {
            if (this.isDirectory()) {
                DirectoryChooser chooser = new DirectoryChooser();
                chooser.titleProperty().bind((ObservableValue)this.chooserTitle);
                File dir = chooser.showDialog((Window)Controllers.getStage());
                if (dir != null) {
                    this.txtCustom.setText(dir.getAbsolutePath());
                }
            } else {
                FileChooser chooser = new FileChooser();
                chooser.getExtensionFilters().addAll(this.getExtensionFilters());
                chooser.titleProperty().bind((ObservableValue)this.chooserTitle);
                File file = chooser.showOpenDialog((Window)Controllers.getStage());
                if (file != null) {
                    this.txtCustom.setText(file.getAbsolutePath());
                }
            }
        });
        this.radioCustom.textProperty().bind((ObservableValue)this.customTitleProperty());
        this.radioCustom.setToggleGroup(this.group);
        this.txtCustom.disableProperty().bind((ObservableValue)this.radioCustom.selectedProperty().not());
        this.btnSelect.disableProperty().bind((ObservableValue)this.radioCustom.selectedProperty().not());
        this.custom.setLeft((Node)this.radioCustom);
        this.custom.setStyle("-fx-padding: 3;");
        HBox right = new HBox();
        right.setSpacing(3.0);
        right.getChildren().addAll((Object[])new Node[]{this.txtCustom, this.btnSelect});
        this.custom.setRight((Node)right);
        FXUtils.setLimitHeight((Region)this.custom, 20.0);
        this.pane.setStyle("-fx-padding: 0 0 10 0;");
        this.pane.setSpacing(8.0);
        if (hasCustom) {
            this.pane.getChildren().add((Object)this.custom);
        }
        this.getContent().add((Object)this.pane);
        this.group.selectedToggleProperty().addListener((a, b, newValue) -> {
            if (this.toggleSelectedListener != null) {
                this.toggleSelectedListener.accept((Toggle)newValue);
            }
            this.selectedData.set(newValue.getUserData());
        });
        this.selectedData.addListener((a, b, newValue) -> {
            Optional<Toggle> selecting = this.group.getToggles().stream().filter(it -> it.getUserData() == newValue).findFirst();
            if (!selecting.isPresent()) {
                selecting = this.group.getToggles().stream().filter(it -> it.getUserData() == this.getFallbackData()).findFirst();
            }
            selecting.ifPresent(toggle -> toggle.setSelected(true));
        });
    }

    public Node createChildren(String title) {
        return this.createChildren(title, null);
    }

    public Node createChildren(String title, T userData) {
        return this.createChildren(title, "", userData);
    }

    public Node createChildren(String title, String subtitle, T userData) {
        BorderPane pane = new BorderPane();
        pane.setPadding(new Insets(3.0));
        FXUtils.setLimitHeight((Region)pane, 20.0);
        JFXRadioButton left = new JFXRadioButton(title);
        left.setToggleGroup(this.group);
        left.setUserData(userData);
        pane.setLeft((Node)left);
        Label right = new Label(subtitle);
        right.setWrapText(true);
        right.getStyleClass().add((Object)"subtitle-label");
        right.setStyle("-fx-font-size: 10;");
        pane.setRight((Node)right);
        return pane;
    }

    public void loadChildren(Collection<Node> list) {
        this.pane.getChildren().setAll(list);
        if (this.hasCustom) {
            this.pane.getChildren().add((Object)this.custom);
        }
    }

    public void loadChildren(Collection<Node> list, T customUserData) {
        this.loadChildren(list);
        this.setCustomUserData(customUserData);
    }

    public ToggleGroup getGroup() {
        return this.group;
    }

    public String getCustomTitle() {
        return (String)this.customTitle.get();
    }

    public StringProperty customTitleProperty() {
        return this.customTitle;
    }

    public void setCustomTitle(String customTitle) {
        this.customTitle.set((Object)customTitle);
    }

    public String getChooserTitle() {
        return (String)this.chooserTitle.get();
    }

    public StringProperty chooserTitleProperty() {
        return this.chooserTitle;
    }

    public void setChooserTitle(String chooserTitle) {
        this.chooserTitle.set((Object)chooserTitle);
    }

    public void setCustomUserData(T userData) {
        this.radioCustom.setUserData(userData);
    }

    public boolean isCustomToggle(Toggle toggle) {
        return this.radioCustom == toggle;
    }

    public void setToggleSelectedListener(Consumer<Toggle> consumer) {
        this.toggleSelectedListener = consumer;
    }

    public StringProperty customTextProperty() {
        return this.txtCustom.textProperty();
    }

    public String getCustomText() {
        return this.txtCustom.getText();
    }

    public void setCustomText(String customText) {
        this.txtCustom.setText(customText);
    }

    public JFXTextField getTxtCustom() {
        return this.txtCustom;
    }

    public boolean isDirectory() {
        return this.directory.get();
    }

    public BooleanProperty directoryProperty() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory.set(directory);
    }

    public ObservableList<FileChooser.ExtensionFilter> getExtensionFilters() {
        return this.extensionFilters;
    }

    public T getSelectedData() {
        return (T)this.selectedData.get();
    }

    public ObjectProperty<T> selectedDataProperty() {
        return this.selectedData;
    }

    public void setSelectedData(T selectedData) {
        this.selectedData.set(selectedData);
    }

    public T getFallbackData() {
        return (T)this.fallbackData.get();
    }

    public ObjectProperty<T> fallbackDataProperty() {
        return this.fallbackData;
    }

    public void setFallbackData(T fallbackData) {
        this.fallbackData.set(fallbackData);
    }
}

