/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.construct;

import com.jfoenix.controls.JFXButton;
import java.util.Optional;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.DialogCloseEvent;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class MessageDialogPane
extends StackPane {
    @FXML
    private JFXButton acceptButton;
    @FXML
    private JFXButton cancelButton;
    @FXML
    private Label content;
    @FXML
    private Label graphic;
    @FXML
    private Label title;
    @FXML
    private HBox actions;

    public MessageDialogPane(String text, String title, MessageType type, Runnable onAccept) {
        FXUtils.loadFXML((Node)this, "/assets/fxml/message-dialog.fxml");
        if (title != null) {
            this.title.setText(title);
        }
        this.content.setText(text);
        this.acceptButton.setOnMouseClicked(e -> {
            this.fireEvent(new DialogCloseEvent());
            Optional.ofNullable(onAccept).ifPresent(Runnable::run);
        });
        this.actions.getChildren().remove((Object)this.cancelButton);
        switch (type) {
            case INFORMATION: {
                this.graphic.setGraphic(SVG.infoCircle(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            case ERROR: {
                this.graphic.setGraphic(SVG.closeCircle(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            case FINE: {
                this.graphic.setGraphic(SVG.checkCircle(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            case WARNING: {
                this.graphic.setGraphic(SVG.alert(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            case QUESTION: {
                this.graphic.setGraphic(SVG.helpCircle(Theme.blackFillBinding(), 40.0, 40.0));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized message box message type " + (Object)((Object)type));
            }
        }
    }

    public MessageDialogPane(String text, String title, Runnable onAccept, Runnable onCancel) {
        this(text, title, MessageType.QUESTION, onAccept);
        this.cancelButton.setVisible(true);
        this.cancelButton.setOnMouseClicked(e -> {
            this.fireEvent(new DialogCloseEvent());
            Optional.ofNullable(onCancel).ifPresent(Runnable::run);
        });
        this.acceptButton.setText(I18n.i18n("button.yes"));
        this.cancelButton.setText(I18n.i18n("button.no"));
        this.actions.getChildren().add((Object)this.cancelButton);
    }

    public static enum MessageType {
        ERROR,
        INFORMATION,
        WARNING,
        QUESTION,
        FINE;

    }
}

