/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.collections.ObservableList;
import javafx.scene.layout.Region;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.ListPage;
import org.jackhuang.hmcl.ui.account.AddAuthlibInjectorServerPane;
import org.jackhuang.hmcl.ui.account.AuthlibInjectorServerItem;
import org.jackhuang.hmcl.ui.decorator.DecoratorPage;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.javafx.MappedObservableList;

public class AuthlibInjectorServersPage
extends ListPage<AuthlibInjectorServerItem>
implements DecoratorPage {
    private final ReadOnlyObjectWrapper<DecoratorPage.State> state = new ReadOnlyObjectWrapper((Object)DecoratorPage.State.fromTitle(I18n.i18n("account.injector.manage.title")));
    private final ObservableList<AuthlibInjectorServerItem> serverItems = MappedObservableList.create(ConfigHolder.config().getAuthlibInjectorServers(), this::createServerItem);

    public AuthlibInjectorServersPage() {
        Bindings.bindContent(this.itemsProperty(), this.serverItems);
    }

    private AuthlibInjectorServerItem createServerItem(AuthlibInjectorServer server) {
        return new AuthlibInjectorServerItem(server, item -> ConfigHolder.config().getAuthlibInjectorServers().remove((Object)item.getServer()));
    }

    @Override
    public void add() {
        Controllers.dialog((Region)new AddAuthlibInjectorServerPane());
    }

    public ReadOnlyObjectWrapper<DecoratorPage.State> stateProperty() {
        return this.state;
    }
}

