/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import java.io.File;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CredentialExpiredException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.offline.OfflineAccount;
import org.jackhuang.hmcl.auth.yggdrasil.CompleteGameProfile;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilAccount;
import org.jackhuang.hmcl.game.TexturesLoader;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.DialogController;
import org.jackhuang.hmcl.ui.account.AccountListItemSkin;
import org.jackhuang.hmcl.ui.account.AddAccountPane;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;

public class AccountListItem
extends RadioButton {
    private final Account account;
    private final StringProperty title = new SimpleStringProperty();
    private final StringProperty subtitle = new SimpleStringProperty();
    private final ObjectProperty<Image> image = new SimpleObjectProperty();

    public AccountListItem(Account account) {
        this.account = account;
        this.getStyleClass().clear();
        this.setUserData(account);
        String loginTypeName = Accounts.getLocalizedLoginTypeName(Accounts.getAccountFactory(account));
        if (account instanceof AuthlibInjectorAccount) {
            AuthlibInjectorServer server = ((AuthlibInjectorAccount)account).getServer();
            Object[] objectArray = new Object[5];
            objectArray[0] = loginTypeName;
            objectArray[1] = ", ";
            objectArray[2] = I18n.i18n("account.injector.server");
            objectArray[3] = ": ";
            objectArray[4] = Bindings.createStringBinding(server::getName, (Observable[])new Observable[]{server});
            this.subtitle.bind((ObservableValue)Bindings.concat((Object[])objectArray));
        } else {
            this.subtitle.set((Object)loginTypeName);
        }
        StringBinding characterName = Bindings.createStringBinding(account::getCharacter, (Observable[])new Observable[]{account});
        if (account instanceof OfflineAccount) {
            this.title.bind((ObservableValue)characterName);
        } else {
            this.title.bind((ObservableValue)(account.getUsername().isEmpty() ? characterName : Bindings.concat((Object[])new Object[]{account.getUsername(), " - ", characterName})));
        }
        this.image.bind(TexturesLoader.fxAvatarBinding(account, 32));
    }

    protected Skin<?> createDefaultSkin() {
        return new AccountListItemSkin(this);
    }

    private Task<?> refreshAsync() {
        return Task.runAsync(() -> {
            this.account.clearCache();
            try {
                this.account.logIn();
            }
            catch (CredentialExpiredException e) {
                try {
                    DialogController.logIn(this.account);
                }
                catch (CancellationException cancellationException) {
                }
                catch (Exception e1) {
                    Logging.LOG.log(Level.WARNING, "Failed to refresh " + this.account + " with password", e1);
                    throw e1;
                }
            }
            catch (AuthenticationException e) {
                Logging.LOG.log(Level.WARNING, "Failed to refresh " + this.account + " with token", e);
                throw e;
            }
        });
    }

    public void refresh() {
        this.refreshAsync().whenComplete(e -> {}).start();
    }

    public ObservableBooleanValue canUploadSkin() {
        if (this.account instanceof YggdrasilAccount) {
            if (this.account instanceof AuthlibInjectorAccount) {
                AuthlibInjectorAccount aiAccount = (AuthlibInjectorAccount)this.account;
                ObjectBinding<Optional<CompleteGameProfile>> profile = aiAccount.getYggdrasilService().getProfileRepository().binding(aiAccount.getUUID());
                return Bindings.createBooleanBinding(() -> {
                    Set uploadableTextures = ((Optional)profile.get()).map(AuthlibInjectorAccount::getUploadableTextures).orElse(Collections.emptySet());
                    return uploadableTextures.contains((Object)TextureType.SKIN);
                }, (Observable[])new Observable[]{profile});
            }
            return Bindings.createBooleanBinding(() -> true, (Observable[])new Observable[0]);
        }
        return Bindings.createBooleanBinding(() -> false, (Observable[])new Observable[0]);
    }

    public void uploadSkin() {
        if (!(this.account instanceof YggdrasilAccount)) {
            return;
        }
        FileChooser chooser = new FileChooser();
        chooser.setTitle(I18n.i18n("account.skin.upload"));
        chooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter(I18n.i18n("account.skin.file"), new String[]{"*.png"}));
        File selectedFile = chooser.showOpenDialog((Window)Controllers.getStage());
        if (selectedFile == null) {
            return;
        }
        Controllers.prompt(new PromptDialogPane.Builder(I18n.i18n("account.skin.upload"), (questions, resolve, reject) -> {
            PromptDialogPane.Builder.CandidatesQuestion q = (PromptDialogPane.Builder.CandidatesQuestion)questions.get(0);
            String model = (Integer)q.getValue() == 0 ? "" : "slim";
            this.refreshAsync().thenRunAsync(() -> ((YggdrasilAccount)this.account).uploadSkin(model, selectedFile.toPath())).thenComposeAsync(this::refreshAsync).thenRunAsync(Schedulers.javafx(), resolve::run).whenComplete(Schedulers.javafx(), e -> {
                if (e != null) {
                    reject.accept(AddAccountPane.accountException(e));
                }
            }).start();
        }).addQuestion(new PromptDialogPane.Builder.CandidatesQuestion(I18n.i18n("account.skin.model"), I18n.i18n("account.skin.model.default"), I18n.i18n("account.skin.model.slim"))));
    }

    public void remove() {
        Accounts.getAccounts().remove((Object)this.account);
    }

    public Account getAccount() {
        return this.account;
    }

    public String getTitle() {
        return (String)this.title.get();
    }

    public void setTitle(String title) {
        this.title.set((Object)title);
    }

    public StringProperty titleProperty() {
        return this.title;
    }

    public String getSubtitle() {
        return (String)this.subtitle.get();
    }

    public void setSubtitle(String subtitle) {
        this.subtitle.set((Object)subtitle);
    }

    public StringProperty subtitleProperty() {
        return this.subtitle;
    }

    public Image getImage() {
        return (Image)this.image.get();
    }

    public void setImage(Image image) {
        this.image.set((Object)image);
    }

    public ObjectProperty<Image> imageProperty() {
        return this.image;
    }
}

