/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.account;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilAccount;
import org.jackhuang.hmcl.game.TexturesLoader;
import org.jackhuang.hmcl.setting.Accounts;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.AdvancedListItem;
import org.jackhuang.hmcl.util.i18n.I18n;

public class AccountAdvancedListItem
extends AdvancedListItem {
    private final Tooltip tooltip;
    private ObjectProperty<Account> account = new SimpleObjectProperty<Account>(){

        protected void invalidated() {
            Account account = (Account)this.get();
            if (account == null) {
                AccountAdvancedListItem.this.titleProperty().unbind();
                AccountAdvancedListItem.this.setTitle(I18n.i18n("account.missing"));
                AccountAdvancedListItem.this.setSubtitle(I18n.i18n("account.missing.add"));
                AccountAdvancedListItem.this.imageProperty().unbind();
                AccountAdvancedListItem.this.setImage(FXUtils.newImage("/assets/img/craft_table.png"));
                AccountAdvancedListItem.this.tooltip.setText("");
            } else {
                AccountAdvancedListItem.this.titleProperty().bind((ObservableValue)Bindings.createStringBinding(account::getCharacter, (Observable[])new Observable[]{account}));
                AccountAdvancedListItem.this.setSubtitle(AccountAdvancedListItem.accountSubtitle(account));
                AccountAdvancedListItem.this.imageProperty().bind(TexturesLoader.fxAvatarBinding(account, 32));
                AccountAdvancedListItem.this.tooltip.setText(account.getCharacter() + " " + AccountAdvancedListItem.accountTooltip(account));
            }
        }
    };

    public AccountAdvancedListItem() {
        this.setRightGraphic(SVG.viewList(Theme.blackFillBinding(), -1.0, -1.0));
        this.tooltip = new Tooltip();
        FXUtils.installFastTooltip((Node)this, this.tooltip);
        this.setOnScroll(event -> {
            Account current = (Account)this.account.get();
            if (current == null) {
                return;
            }
            ObservableList<Account> accounts = Accounts.getAccounts();
            int currentIndex = accounts.indexOf(this.account.get());
            currentIndex = event.getDeltaY() > 0.0 ? --currentIndex : ++currentIndex;
            Accounts.setSelectedAccount((Account)accounts.get((currentIndex + accounts.size()) % accounts.size()));
        });
    }

    public ObjectProperty<Account> accountProperty() {
        return this.account;
    }

    private static String accountSubtitle(Account account) {
        String loginTypeName = Accounts.getLocalizedLoginTypeName(Accounts.getAccountFactory(account));
        if (account instanceof AuthlibInjectorAccount) {
            return ((AuthlibInjectorAccount)account).getServer().getName();
        }
        return loginTypeName;
    }

    private static String accountTooltip(Account account) {
        if (account instanceof AuthlibInjectorAccount) {
            AuthlibInjectorServer server = ((AuthlibInjectorAccount)account).getServer();
            return account.getUsername() + ", " + I18n.i18n("account.injector.server") + ": " + server.getName();
        }
        if (account instanceof YggdrasilAccount) {
            return account.getUsername();
        }
        return "";
    }
}

