/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXListCell;
import com.jfoenix.controls.JFXPasswordField;
import com.jfoenix.controls.JFXPopup;
import com.jfoenix.controls.JFXScrollPane;
import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXToggleButton;
import com.jfoenix.controls.JFXTreeTableColumn;
import java.awt.Desktop;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.ResourceNotFoundError;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.javafx.SafeStringConverter;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class FXUtils {
    public static final Interpolator SINE = new Interpolator(){

        protected double curve(double t) {
            return Math.sin(t * Math.PI / 2.0);
        }

        public String toString() {
            return "Interpolator.SINE";
        }
    };

    private FXUtils() {
    }

    public static void runInFX(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static void checkFxUserThread() {
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Not on FX application thread; currentThread = " + Thread.currentThread().getName());
        }
    }

    public static InvalidationListener onInvalidating(Runnable action) {
        return arg -> action.run();
    }

    public static <T> void onChange(ObservableValue<T> value, Consumer<T> consumer) {
        value.addListener((a, b, c) -> consumer.accept(c));
    }

    public static <T> WeakChangeListener<T> onWeakChange(ObservableValue<T> value, Consumer<T> consumer) {
        WeakChangeListener listener = new WeakChangeListener((a, b, c) -> consumer.accept(c));
        value.addListener((ChangeListener)listener);
        return listener;
    }

    public static <T> void onChangeAndOperate(ObservableValue<T> value, Consumer<T> consumer) {
        consumer.accept(value.getValue());
        FXUtils.onChange(value, consumer);
    }

    public static <T> WeakChangeListener<T> onWeakChangeAndOperate(ObservableValue<T> value, Consumer<T> consumer) {
        consumer.accept(value.getValue());
        return FXUtils.onWeakChange(value, consumer);
    }

    public static void runLaterIf(BooleanSupplier condition, Runnable runnable) {
        if (condition.getAsBoolean()) {
            Platform.runLater(() -> FXUtils.runLaterIf(condition, runnable));
        } else {
            runnable.run();
        }
    }

    public static void limitSize(ImageView imageView, double maxWidth, double maxHeight) {
        imageView.setPreserveRatio(true);
        FXUtils.onChangeAndOperate(imageView.imageProperty(), image -> {
            if (image != null && (image.getWidth() > maxWidth || image.getHeight() > maxHeight)) {
                imageView.setFitHeight(maxHeight);
                imageView.setFitWidth(maxWidth);
            } else {
                imageView.setFitHeight(-1.0);
                imageView.setFitWidth(-1.0);
            }
        });
    }

    public static <T> void addListener(Node node, String key, ObservableValue<T> value, Consumer<? super T> callback) {
        ListenerPair<T> pair = new ListenerPair<T>(value, (a, b, newValue) -> callback.accept(newValue));
        node.getProperties().put((Object)key, pair);
        pair.bind();
    }

    public static void removeListener(Node node, String key) {
        Lang.tryCast(node.getProperties().get((Object)key), ListenerPair.class).ifPresent(info -> {
            info.unbind();
            node.getProperties().remove((Object)key);
        });
    }

    public static <K, T> void setupCellValueFactory(JFXTreeTableColumn<K, T> column, Function<K, ObservableValue<T>> mapper) {
        column.setCellValueFactory(param -> {
            if (column.validateValue((TreeTableColumn.CellDataFeatures)param)) {
                return (ObservableValue)mapper.apply(param.getValue().getValue());
            }
            return column.getComputedValue((TreeTableColumn.CellDataFeatures)param);
        });
    }

    public static Node wrapMargin(Node node, Insets insets) {
        StackPane.setMargin((Node)node, (Insets)insets);
        return new StackPane(new Node[]{node});
    }

    public static void setValidateWhileTextChanged(Node field, boolean validate) {
        if (field instanceof JFXTextField) {
            if (validate) {
                FXUtils.addListener(field, "FXUtils.validation", ((JFXTextField)field).textProperty(), o -> ((JFXTextField)field).validate());
            } else {
                FXUtils.removeListener(field, "FXUtils.validation");
            }
            ((JFXTextField)field).validate();
        } else if (field instanceof JFXPasswordField) {
            if (validate) {
                FXUtils.addListener(field, "FXUtils.validation", ((JFXPasswordField)field).textProperty(), o -> ((JFXPasswordField)field).validate());
            } else {
                FXUtils.removeListener(field, "FXUtils.validation");
            }
            ((JFXPasswordField)field).validate();
        } else {
            throw new IllegalArgumentException("Only JFXTextField and JFXPasswordField allowed");
        }
    }

    public static boolean getValidateWhileTextChanged(Node field) {
        return field.getProperties().containsKey((Object)"FXUtils.validation");
    }

    public static Rectangle setOverflowHidden(Region region) {
        Rectangle rectangle = new Rectangle();
        rectangle.widthProperty().bind((ObservableValue)region.widthProperty());
        rectangle.heightProperty().bind((ObservableValue)region.heightProperty());
        region.setClip((Node)rectangle);
        return rectangle;
    }

    public static Rectangle setOverflowHidden(Region region, double arc) {
        Rectangle rectangle = FXUtils.setOverflowHidden(region);
        rectangle.setArcWidth(arc);
        rectangle.setArcHeight(arc);
        return rectangle;
    }

    public static void setLimitWidth(Region region, double width) {
        region.setMaxWidth(width);
        region.setMinWidth(width);
        region.setPrefWidth(width);
    }

    public static double getLimitWidth(Region region) {
        return region.getMaxWidth();
    }

    public static void setLimitHeight(Region region, double height) {
        region.setMaxHeight(height);
        region.setMinHeight(height);
        region.setPrefHeight(height);
    }

    public static double getLimitHeight(Region region) {
        return region.getMaxHeight();
    }

    public static Node limitingSize(Node node, double width, double height) {
        StackPane pane = new StackPane(new Node[]{node});
        pane.setAlignment(Pos.CENTER);
        FXUtils.setLimitWidth((Region)pane, width);
        FXUtils.setLimitHeight((Region)pane, height);
        return pane;
    }

    public static void smoothScrolling(ScrollPane scrollPane) {
        JFXScrollPane.smoothScrolling(scrollPane);
    }

    public static void loadFXML(Node node, String absolutePath) {
        FXMLLoader loader = new FXMLLoader(node.getClass().getResource(absolutePath), I18n.getResourceBundle());
        loader.setRoot((Object)node);
        loader.setController((Object)node);
        try {
            loader.load();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void installFastTooltip(Node node, Tooltip tooltip) {
        FXUtils.installTooltip(node, 50.0, 5000.0, 0.0, tooltip);
    }

    public static void installFastTooltip(Node node, String tooltip) {
        FXUtils.installFastTooltip(node, new Tooltip(tooltip));
    }

    public static void installSlowTooltip(Node node, Tooltip tooltip) {
        FXUtils.installTooltip(node, 500.0, 5000.0, 0.0, tooltip);
    }

    public static void installSlowTooltip(Node node, String tooltip) {
        FXUtils.installSlowTooltip(node, new Tooltip(tooltip));
    }

    public static void installTooltip(Node node, double openDelay, double visibleDelay, double closeDelay, Tooltip tooltip) {
        FXUtils.runInFX(() -> {
            try {
                Class<?> behaviorClass = Class.forName("javafx.scene.control.Tooltip$TooltipBehavior");
                Constructor<?> behaviorConstructor = behaviorClass.getDeclaredConstructor(Duration.class, Duration.class, Duration.class, Boolean.TYPE);
                behaviorConstructor.setAccessible(true);
                Object behavior = behaviorConstructor.newInstance(new Duration(openDelay), new Duration(visibleDelay), new Duration(closeDelay), false);
                Method installMethod = behaviorClass.getDeclaredMethod("install", Node.class, Tooltip.class);
                installMethod.setAccessible(true);
                installMethod.invoke(behavior, node, tooltip);
            }
            catch (ReflectiveOperationException e) {
                try {
                    Tooltip.class.getMethod("setShowDelay", Duration.class).invoke((Object)tooltip, new Duration(openDelay));
                    Tooltip.class.getMethod("setShowDuration", Duration.class).invoke((Object)tooltip, new Duration(visibleDelay));
                    Tooltip.class.getMethod("setHideDelay", Duration.class).invoke((Object)tooltip, new Duration(closeDelay));
                }
                catch (ReflectiveOperationException e2) {
                    e.addSuppressed(e2);
                    Logging.LOG.log(Level.SEVERE, "Cannot install tooltip", e);
                }
                Tooltip.install((Node)node, (Tooltip)tooltip);
            }
        });
    }

    public static void playAnimation(Node node, String animationKey, Timeline timeline) {
        animationKey = "FXUTILS.ANIMATION." + animationKey;
        Object oldTimeline = node.getProperties().get((Object)animationKey);
        if (oldTimeline instanceof Timeline) {
            ((Timeline)oldTimeline).stop();
        }
        if (timeline != null) {
            timeline.play();
        }
        node.getProperties().put((Object)animationKey, (Object)timeline);
    }

    public static <T> void playAnimation(Node node, String animationKey, Duration duration, WritableValue<T> property, T from, T to, Interpolator interpolator) {
        if (from == null) {
            from = property.getValue();
        }
        if (duration == null || Objects.equals(duration, Duration.ZERO) || Objects.equals(from, to)) {
            FXUtils.playAnimation(node, animationKey, null);
            property.setValue(to);
        } else {
            FXUtils.playAnimation(node, animationKey, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue(property, from, interpolator)}), new KeyFrame(duration, new KeyValue[]{new KeyValue(property, to, interpolator)})}));
        }
    }

    public static void openFolder(File file) {
        if (!FileUtils.makeDirectory(file)) {
            Logging.LOG.log(Level.SEVERE, "Unable to make directory " + file);
            return;
        }
        String path = file.getAbsolutePath();
        switch (OperatingSystem.CURRENT_OS) {
            case OSX: {
                try {
                    Runtime.getRuntime().exec(new String[]{"/usr/bin/open", path});
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.SEVERE, "Unable to open " + path + " by executing /usr/bin/open", e);
                }
                break;
            }
            default: {
                Lang.thread(() -> {
                    if (Desktop.isDesktopSupported()) {
                        try {
                            Desktop.getDesktop().open(file);
                        }
                        catch (Throwable e) {
                            Logging.LOG.log(Level.SEVERE, "Unable to open " + path + " by java.awt.Desktop.getDesktop()::open", e);
                        }
                    }
                });
            }
        }
    }

    public static void openLink(String link) {
        if (link == null) {
            return;
        }
        Lang.thread(() -> {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI(link));
                }
                catch (Throwable e) {
                    if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
                        try {
                            Runtime.getRuntime().exec(new String[]{"/usr/bin/open", link});
                        }
                        catch (IOException ex) {
                            Logging.LOG.log(Level.WARNING, "Unable to open link: " + link, ex);
                        }
                    }
                    Logging.LOG.log(Level.WARNING, "Failed to open link: " + link, e);
                }
            }
        });
    }

    public static void bindInt(JFXTextField textField, Property<Number> property) {
        textField.textProperty().bindBidirectional(property, SafeStringConverter.fromInteger());
    }

    public static void unbindInt(JFXTextField textField, Property<Number> property) {
        textField.textProperty().unbindBidirectional(property);
    }

    public static void bindString(JFXTextField textField, Property<String> property) {
        textField.textProperty().bindBidirectional(property);
    }

    public static void unbindString(JFXTextField textField, Property<String> property) {
        textField.textProperty().unbindBidirectional(property);
    }

    public static void bindBoolean(JFXToggleButton toggleButton, Property<Boolean> property) {
        toggleButton.selectedProperty().bindBidirectional(property);
    }

    public static void unbindBoolean(JFXToggleButton toggleButton, Property<Boolean> property) {
        toggleButton.selectedProperty().unbindBidirectional(property);
    }

    public static void bindBoolean(JFXCheckBox checkBox, Property<Boolean> property) {
        checkBox.selectedProperty().bindBidirectional(property);
    }

    public static void unbindBoolean(JFXCheckBox checkBox, Property<Boolean> property) {
        checkBox.selectedProperty().unbindBidirectional(property);
    }

    @Deprecated
    public static void bindEnum(JFXComboBox<?> comboBox, Property<? extends Enum<?>> property) {
        FXUtils.unbindEnum(comboBox);
        ChangeListener listener = (a, b, newValue) -> property.setValue((Object)((Enum[])((Enum)property.getValue()).getClass().getEnumConstants())[newValue.intValue()]);
        comboBox.getSelectionModel().select(((Enum)property.getValue()).ordinal());
        comboBox.getProperties().put((Object)"FXUtils.bindEnum.listener", (Object)listener);
        comboBox.getSelectionModel().selectedIndexProperty().addListener(listener);
    }

    @Deprecated
    public static void unbindEnum(JFXComboBox<?> comboBox) {
        ChangeListener listener = Lang.tryCast(comboBox.getProperties().get((Object)"FXUtils.bindEnum.listener"), ChangeListener.class).orElse(null);
        if (listener == null) {
            return;
        }
        comboBox.getSelectionModel().selectedIndexProperty().removeListener(listener);
    }

    public static Image newImage(String url) {
        try {
            return new Image(url);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceNotFoundError("Cannot access image: " + url, e);
        }
    }

    public static void applyDragListener(Node node, FileFilter filter, Consumer<List<File>> callback) {
        FXUtils.applyDragListener(node, filter, callback, null);
    }

    public static void applyDragListener(Node node, FileFilter filter, Consumer<List<File>> callback, Runnable dragDropped) {
        node.setOnDragOver(event -> {
            if (event.getGestureSource() != node && event.getDragboard().hasFiles()) {
                if (event.getDragboard().getFiles().stream().anyMatch(filter::accept)) {
                    event.acceptTransferModes(TransferMode.COPY_OR_MOVE);
                }
            }
            event.consume();
        });
        node.setOnDragDropped(event -> {
            List files = event.getDragboard().getFiles();
            if (files != null) {
                List acceptFiles = files.stream().filter(filter::accept).collect(Collectors.toList());
                if (!acceptFiles.isEmpty()) {
                    callback.accept(acceptFiles);
                    event.setDropCompleted(true);
                }
            }
            if (dragDropped != null) {
                dragDropped.run();
            }
            event.consume();
        });
    }

    public static <T> StringConverter<T> stringConverter(final Function<T, String> func) {
        return new StringConverter<T>(){

            public String toString(T object) {
                return object == null ? "" : (String)func.apply(object);
            }

            public T fromString(String string) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Callback<ListView<T>, ListCell<T>> jfxListCellFactory(final Function<T, Node> graphicBuilder) {
        return view -> new JFXListCell<T>(){

            @Override
            public void updateItem(T item, boolean empty) {
                super.updateItem(item, empty);
                if (!empty) {
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    this.setGraphic((Node)graphicBuilder.apply(item));
                }
            }
        };
    }

    public static Runnable withJFXPopupClosing(Runnable runnable, JFXPopup popup) {
        return () -> {
            runnable.run();
            popup.hide();
        };
    }

    private static class ListenerPair<T> {
        private final ObservableValue<T> value;
        private final ChangeListener<? super T> listener;

        ListenerPair(ObservableValue<T> value, ChangeListener<? super T> listener) {
            this.value = value;
            this.listener = listener;
        }

        void bind() {
            this.value.addListener(this.listener);
        }

        void unbind() {
            this.value.removeListener(this.listener);
        }
    }
}

