/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.jackhuang.hmcl.Launcher;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumCommonDirectory;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.task.TaskExecutor;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.account.AuthlibInjectorServersPage;
import org.jackhuang.hmcl.ui.account.MicrosoftAccountLoginStage;
import org.jackhuang.hmcl.ui.animation.ContainerAnimations;
import org.jackhuang.hmcl.ui.construct.InputDialogPane;
import org.jackhuang.hmcl.ui.construct.MessageDialogPane;
import org.jackhuang.hmcl.ui.construct.PromptDialogPane;
import org.jackhuang.hmcl.ui.construct.TaskExecutorDialogPane;
import org.jackhuang.hmcl.ui.decorator.DecoratorController;
import org.jackhuang.hmcl.ui.main.RootPage;
import org.jackhuang.hmcl.ui.versions.VersionPage;
import org.jackhuang.hmcl.util.FutureCallback;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.JavaVersion;

public final class Controllers {
    private static DoubleProperty stageWidth = new SimpleDoubleProperty();
    private static DoubleProperty stageHeight = new SimpleDoubleProperty();
    private static Scene scene;
    private static Stage stage;
    private static VersionPage versionPage;
    private static AuthlibInjectorServersPage serversPage;
    private static RootPage rootPage;
    private static DecoratorController decorator;

    public static Scene getScene() {
        return scene;
    }

    public static Stage getStage() {
        return stage;
    }

    public static VersionPage getVersionPage() {
        if (versionPage == null) {
            versionPage = new VersionPage();
        }
        return versionPage;
    }

    public static RootPage getRootPage() {
        if (rootPage == null) {
            rootPage = new RootPage();
        }
        return rootPage;
    }

    public static AuthlibInjectorServersPage getServersPage() {
        if (serversPage == null) {
            serversPage = new AuthlibInjectorServersPage();
        }
        return serversPage;
    }

    public static DecoratorController getDecorator() {
        return decorator;
    }

    public static void onApplicationStop() {
        ConfigHolder.config().setHeight(stageHeight.get());
        ConfigHolder.config().setWidth(stageWidth.get());
    }

    public static void initialize(Stage stage) {
        Logging.LOG.info("Start initializing application");
        Controllers.stage = stage;
        MicrosoftAccountLoginStage.INSTANCE.initOwner((Window)stage);
        stage.setHeight(ConfigHolder.config().getHeight());
        stageHeight.bind((ObservableValue)stage.heightProperty());
        stage.setWidth(ConfigHolder.config().getWidth());
        stageWidth.bind((ObservableValue)stage.widthProperty());
        stage.setOnCloseRequest(e -> Launcher.stopApplication());
        decorator = new DecoratorController(stage, (Node)Controllers.getRootPage());
        if (ConfigHolder.config().getCommonDirType() == EnumCommonDirectory.CUSTOM && !FileUtils.canCreateDirectory(ConfigHolder.config().getCommonDirectory())) {
            ConfigHolder.config().setCommonDirType(EnumCommonDirectory.DEFAULT);
            Controllers.dialog(I18n.i18n("launcher.cache_directory.invalid"));
        }
        Task.runAsync(JavaVersion::initialize).start();
        scene = new Scene((Parent)decorator.getDecorator());
        scene.setFill((Paint)Color.TRANSPARENT);
        stage.setMinHeight(514.0);
        stage.setMinWidth(834.0);
        decorator.getDecorator().prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        decorator.getDecorator().prefHeightProperty().bind((ObservableValue)scene.heightProperty());
        scene.getStylesheets().setAll((Object[])ConfigHolder.config().getTheme().getStylesheets());
        stage.getIcons().add((Object)FXUtils.newImage("/assets/img/icon.png"));
        stage.setTitle(Metadata.TITLE);
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.setScene(scene);
    }

    public static void dialog(Region content) {
        if (decorator != null) {
            decorator.showDialog((Node)content);
        }
    }

    public static void dialog(String text) {
        Controllers.dialog(text, null);
    }

    public static void dialog(String text, String title) {
        Controllers.dialog(text, title, MessageDialogPane.MessageType.INFORMATION);
    }

    public static void dialog(String text, String title, MessageDialogPane.MessageType type) {
        Controllers.dialog(text, title, type, null);
    }

    public static void dialog(String text, String title, MessageDialogPane.MessageType type, Runnable onAccept) {
        Controllers.dialog((Region)new MessageDialogPane(text, title, type, onAccept));
    }

    public static void confirm(String text, String title, Runnable onAccept, Runnable onCancel) {
        Controllers.dialog((Region)new MessageDialogPane(text, title, onAccept, onCancel));
    }

    public static CompletableFuture<String> prompt(String title, FutureCallback<String> onResult) {
        return Controllers.prompt(title, onResult, "");
    }

    public static CompletableFuture<String> prompt(String title, FutureCallback<String> onResult, String initialValue) {
        InputDialogPane pane = new InputDialogPane(title, initialValue, onResult);
        Controllers.dialog((Region)pane);
        return pane.getCompletableFuture();
    }

    public static CompletableFuture<List<PromptDialogPane.Builder.Question<?>>> prompt(PromptDialogPane.Builder builder) {
        PromptDialogPane pane = new PromptDialogPane(builder);
        Controllers.dialog((Region)pane);
        return pane.getCompletableFuture();
    }

    public static TaskExecutorDialogPane taskDialog(TaskExecutor executor, String title) {
        return Controllers.taskDialog(executor, title, null);
    }

    public static TaskExecutorDialogPane taskDialog(TaskExecutor executor, String title, Consumer<Region> onCancel) {
        TaskExecutorDialogPane pane = new TaskExecutorDialogPane(onCancel);
        pane.setTitle(title);
        pane.setExecutor(executor);
        Controllers.dialog((Region)pane);
        return pane;
    }

    public static void navigate(Node node) {
        decorator.getNavigator().navigate(node, ContainerAnimations.FADE.getAnimationProducer());
    }

    public static boolean isStopped() {
        return decorator == null;
    }

    public static void shutdown() {
        rootPage = null;
        versionPage = null;
        serversPage = null;
        decorator = null;
        stage = null;
        scene = null;
    }

    static {
        versionPage = null;
        serversPage = null;
    }
}

