/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.task;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventBus;
import org.jackhuang.hmcl.task.DownloadException;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.CacheRepository;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;

public abstract class FetchTask<T>
extends Task<T> {
    protected final List<URL> urls;
    protected final int retry;
    protected boolean caching;
    protected CacheRepository repository = CacheRepository.getInstance();
    private static final Timer timer = new Timer("DownloadSpeedRecorder", true);
    private static final AtomicInteger downloadSpeed = new AtomicInteger(0);
    public static final EventBus speedEvent = new EventBus();
    private static int downloadExecutorConcurrency;
    private static volatile ExecutorService DOWNLOAD_EXECUTOR;

    public FetchTask(List<URL> urls, int retry) {
        if (urls == null || urls.isEmpty()) {
            throw new IllegalArgumentException("At least one URL is required");
        }
        this.urls = new ArrayList<URL>(urls);
        this.retry = retry;
        this.setExecutor(FetchTask.download());
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public void setCacheRepository(CacheRepository repository) {
        this.repository = repository;
    }

    protected void beforeDownload(URL url) throws IOException {
    }

    protected abstract void useCachedResult(Path var1) throws IOException;

    protected abstract EnumCheckETag shouldCheckETag();

    protected abstract Context getContext(URLConnection var1, boolean var2) throws IOException;

    @Override
    public void execute() throws Exception {
        boolean checkETag;
        IOException exception = null;
        URL failedURL = null;
        switch (this.shouldCheckETag()) {
            case CHECK_E_TAG: {
                checkETag = true;
                break;
            }
            case NOT_CHECK_E_TAG: {
                checkETag = false;
                break;
            }
            default: {
                return;
            }
        }
        int repeat = 0;
        block32: for (URL url : this.urls) {
            for (int retryTime = 0; retryTime < this.retry; ++retryTime) {
                if (this.isCancelled()) break block32;
                try {
                    this.beforeDownload(url);
                    this.updateProgress(0.0);
                    URLConnection conn = NetworkUtils.createConnection(url);
                    if (checkETag) {
                        this.repository.injectConnection(conn);
                    }
                    if (conn instanceof HttpURLConnection) {
                        int responseCode = ((HttpURLConnection)(conn = NetworkUtils.resolveConnection((HttpURLConnection)conn))).getResponseCode();
                        if (responseCode == 304) {
                            try {
                                Path cache = this.repository.getCachedRemoteFile(conn);
                                this.useCachedResult(cache);
                                return;
                            }
                            catch (IOException e) {
                                Logging.LOG.log(Level.WARNING, "Unable to use cached file, redownload " + url, e);
                                this.repository.removeRemoteEntry(conn);
                                --retryTime;
                                continue;
                            }
                        }
                        if (responseCode / 100 == 4) continue block32;
                        if (responseCode / 100 != 2) {
                            throw new ResponseCodeException(url, responseCode);
                        }
                    }
                    long contentLength = conn.getContentLength();
                    try (Context context = this.getContext(conn, checkETag);
                         InputStream stream = conn.getInputStream();){
                        int len;
                        int lastDownloaded = 0;
                        int downloaded = 0;
                        byte[] buffer = new byte[8192];
                        while (!this.isCancelled() && (len = stream.read(buffer)) != -1) {
                            context.write(buffer, 0, len);
                            downloaded += len;
                            if (contentLength >= 0L) {
                                this.updateProgress(downloaded, contentLength);
                            }
                            FetchTask.updateDownloadSpeed(downloaded - lastDownloaded);
                            lastDownloaded = downloaded;
                        }
                        if (this.isCancelled()) break block32;
                        FetchTask.updateDownloadSpeed(downloaded - lastDownloaded);
                        if (contentLength >= 0L && (long)downloaded != contentLength) {
                            throw new IOException("Unexpected file size: " + downloaded + ", expected: " + contentLength);
                        }
                        context.withResult(true);
                    }
                    return;
                }
                catch (IOException ex) {
                    failedURL = url;
                    exception = ex;
                    Logging.LOG.log(Level.WARNING, "Failed to download " + url + ", repeat times: " + ++repeat, ex);
                }
            }
        }
        if (exception != null) {
            throw new DownloadException(failedURL, exception);
        }
    }

    private static void updateDownloadSpeed(int speed) {
        downloadSpeed.addAndGet(speed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ExecutorService download() {
        if (DOWNLOAD_EXECUTOR != null) return DOWNLOAD_EXECUTOR;
        Class<Schedulers> clazz = Schedulers.class;
        synchronized (Schedulers.class) {
            if (DOWNLOAD_EXECUTOR != null) return DOWNLOAD_EXECUTOR;
            DOWNLOAD_EXECUTOR = Lang.threadPool("Download", true, downloadExecutorConcurrency, 10L, TimeUnit.SECONDS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return DOWNLOAD_EXECUTOR;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDownloadExecutorConcurrency(int concurrency) {
        Class<Schedulers> clazz = Schedulers.class;
        synchronized (Schedulers.class) {
            downloadExecutorConcurrency = concurrency;
            if (DOWNLOAD_EXECUTOR != null) {
                DOWNLOAD_EXECUTOR.shutdownNow();
                DOWNLOAD_EXECUTOR = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDownloadExecutorConcurrency() {
        Class<Schedulers> clazz = Schedulers.class;
        synchronized (Schedulers.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return downloadExecutorConcurrency;
        }
    }

    static {
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                speedEvent.channel(SpeedEvent.class).fireEvent(new SpeedEvent(speedEvent, downloadSpeed.getAndSet(0)));
            }
        }, 0L, 1000L);
        downloadExecutorConcurrency = Math.min(Runtime.getRuntime().availableProcessors() * 4, 64);
    }

    protected static abstract class Context
    implements Closeable {
        private boolean success;

        protected Context() {
        }

        public abstract void write(byte[] var1, int var2, int var3) throws IOException;

        public final void withResult(boolean success) {
            this.success = success;
        }

        protected boolean isSuccess() {
            return this.success;
        }
    }

    protected class DownloadMission {
        protected DownloadMission() {
        }
    }

    protected class DownloadState {
        private final int startPosition;
        private final int endPosition;
        private final int currentPosition;
        private final boolean finished;

        public DownloadState(int startPosition, int endPosition, int currentPosition) {
            if (currentPosition < startPosition || currentPosition > endPosition) {
                throw new IllegalArgumentException("Illegal download state: start " + startPosition + ", end " + endPosition + ", cur " + currentPosition);
            }
            this.startPosition = startPosition;
            this.endPosition = endPosition;
            this.currentPosition = currentPosition;
            this.finished = currentPosition == endPosition;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public int getEndPosition() {
            return this.endPosition;
        }

        public int getCurrentPosition() {
            return this.currentPosition;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    protected static enum EnumCheckETag {
        CHECK_E_TAG,
        NOT_CHECK_E_TAG,
        CACHED;

    }

    public static class SpeedEvent
    extends Event {
        private final int speed;

        public SpeedEvent(Object source, int speed) {
            super(source);
            this.speed = speed;
        }

        public int getSpeed() {
            return this.speed;
        }

        @Override
        public String toString() {
            return new ToStringBuilder(this).append("speed", this.speed).toString();
        }
    }
}

