/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.download.AdaptedDownloadProvider;
import org.jackhuang.hmcl.download.BMCLAPIDownloadProvider;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.MojangDownloadProvider;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;

public final class DownloadProviders {
    private static final AdaptedDownloadProvider DOWNLOAD_PROVIDER = new AdaptedDownloadProvider();
    public static final Map<String, DownloadProvider> providersById;
    public static final String DEFAULT_PROVIDER_ID = "mcbbs";

    private DownloadProviders() {
    }

    static void init() {
        FXUtils.onChangeAndOperate(ConfigHolder.config().downloadTypeProperty(), downloadType -> {
            DownloadProvider primary = Optional.ofNullable(providersById.get(ConfigHolder.config().getDownloadType())).orElse(providersById.get(DEFAULT_PROVIDER_ID));
            DOWNLOAD_PROVIDER.setDownloadProviderCandidates(Stream.concat(Stream.of(primary), providersById.values().stream().filter(x -> x != primary)).collect(Collectors.toList()));
        });
    }

    public static String getPrimaryDownloadProviderId() {
        String downloadType = ConfigHolder.config().getDownloadType();
        if (providersById.containsKey(downloadType)) {
            return downloadType;
        }
        return DEFAULT_PROVIDER_ID;
    }

    public static AdaptedDownloadProvider getDownloadProviderByPrimaryId(String primaryId) {
        AdaptedDownloadProvider adaptedDownloadProvider = new AdaptedDownloadProvider();
        DownloadProvider primary = Optional.ofNullable(providersById.get(primaryId)).orElse(providersById.get(DEFAULT_PROVIDER_ID));
        adaptedDownloadProvider.setDownloadProviderCandidates(Stream.concat(Stream.of(primary), providersById.values().stream().filter(x -> x != primary)).collect(Collectors.toList()));
        return adaptedDownloadProvider;
    }

    public static AdaptedDownloadProvider getDownloadProvider() {
        return DOWNLOAD_PROVIDER;
    }

    static {
        String bmclapiRoot = "https://bmclapi2.bangbang93.com";
        String bmclapiRootOverride = System.getProperty("hmcl.bmclapi.override");
        if (bmclapiRootOverride != null) {
            bmclapiRoot = bmclapiRootOverride;
        }
        providersById = Lang.mapOf(Pair.pair("mojang", new MojangDownloadProvider()), Pair.pair("bmclapi", new BMCLAPIDownloadProvider(bmclapiRoot)), Pair.pair(DEFAULT_PROVIDER_ID, new BMCLAPIDownloadProvider("https://download.mcbbs.net")));
    }
}

