/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.setting;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.ObservableList;
import org.jackhuang.hmcl.Metadata;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccount;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorAccountFactory;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactInfo;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorDownloader;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorServer;
import org.jackhuang.hmcl.auth.authlibinjector.SimpleAuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccount;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftAccountFactory;
import org.jackhuang.hmcl.auth.offline.OfflineAccount;
import org.jackhuang.hmcl.auth.offline.OfflineAccountFactory;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilAccount;
import org.jackhuang.hmcl.auth.yggdrasil.YggdrasilAccountFactory;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.DownloadProviders;
import org.jackhuang.hmcl.task.Schedulers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.i18n.I18n;

public final class Accounts {
    private static final AuthlibInjectorArtifactProvider AUTHLIB_INJECTOR_DOWNLOADER;
    public static final OfflineAccountFactory FACTORY_OFFLINE;
    public static final YggdrasilAccountFactory FACTORY_MOJANG;
    public static final AuthlibInjectorAccountFactory FACTORY_AUTHLIB_INJECTOR;
    public static final MicrosoftAccountFactory FACTORY_MICROSOFT;
    public static final List<AccountFactory<?>> FACTORIES;
    private static final Map<String, AccountFactory<?>> type2factory;
    private static final Map<AccountFactory<?>, String> factory2type;
    private static ObservableList<Account> accounts;
    private static ReadOnlyListWrapper<Account> accountsWrapper;
    private static ObjectProperty<Account> selectedAccount;
    private static boolean initialized;
    private static Map<AccountFactory<?>, String> unlocalizedLoginTypeNames;

    private Accounts() {
    }

    private static void triggerAuthlibInjectorUpdateCheck() {
        if (AUTHLIB_INJECTOR_DOWNLOADER instanceof AuthlibInjectorDownloader) {
            Schedulers.io().execute(() -> {
                try {
                    ((AuthlibInjectorDownloader)AUTHLIB_INJECTOR_DOWNLOADER).checkUpdate();
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to check update for authlib-injector", e);
                }
            });
        }
    }

    public static String getLoginType(AccountFactory<?> factory) {
        return Optional.ofNullable(factory2type.get(factory)).orElseThrow(() -> new IllegalArgumentException("Unrecognized account factory"));
    }

    public static AccountFactory<?> getAccountFactory(String loginType) {
        return Optional.ofNullable(type2factory.get(loginType)).orElseThrow(() -> new IllegalArgumentException("Unrecognized login type"));
    }

    public static AccountFactory<?> getAccountFactory(Account account) {
        if (account instanceof OfflineAccount) {
            return FACTORY_OFFLINE;
        }
        if (account instanceof AuthlibInjectorAccount) {
            return FACTORY_AUTHLIB_INJECTOR;
        }
        if (account instanceof YggdrasilAccount) {
            return FACTORY_MOJANG;
        }
        if (account instanceof MicrosoftAccount) {
            return FACTORY_MICROSOFT;
        }
        throw new IllegalArgumentException("Failed to determine account type: " + account);
    }

    private static Map<Object, Object> getAccountStorage(Account account) {
        Map<Object, Object> storage = account.toStorage();
        storage.put("type", Accounts.getLoginType(Accounts.getAccountFactory(account)));
        if (account == selectedAccount.get()) {
            storage.put("selected", true);
        }
        return storage;
    }

    private static void updateAccountStorages() {
        if (!initialized) {
            return;
        }
        ConfigHolder.config().getAccountStorages().setAll((Collection)accounts.stream().map(Accounts::getAccountStorage).collect(Collectors.toList()));
    }

    static void init() {
        if (initialized) {
            throw new IllegalStateException("Already initialized");
        }
        ConfigHolder.config().getAccountStorages().forEach(storage -> {
            Object account;
            AccountFactory<?> factory = type2factory.get(storage.get("type"));
            if (factory == null) {
                Logging.LOG.warning("Unrecognized account type: " + storage);
                return;
            }
            try {
                account = factory.fromStorage((Map<Object, Object>)storage);
            }
            catch (Exception e) {
                Logging.LOG.log(Level.WARNING, "Failed to load account: " + storage, e);
                return;
            }
            accounts.add(account);
            if (Boolean.TRUE.equals(storage.get("selected"))) {
                selectedAccount.set(account);
            }
        });
        initialized = true;
        ConfigHolder.config().getAuthlibInjectorServers().addListener(FXUtils.onInvalidating(Accounts::removeDanglingAuthlibInjectorAccounts));
        Account selected = (Account)selectedAccount.get();
        if (selected != null) {
            Schedulers.io().execute(() -> {
                try {
                    selected.logIn();
                }
                catch (AuthenticationException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to log " + selected + " in", e);
                }
            });
        }
        if (!ConfigHolder.config().getAuthlibInjectorServers().isEmpty()) {
            Accounts.triggerAuthlibInjectorUpdateCheck();
        }
        for (AuthlibInjectorServer server : ConfigHolder.config().getAuthlibInjectorServers()) {
            if (selected instanceof AuthlibInjectorAccount && ((AuthlibInjectorAccount)selected).getServer() == server) continue;
            Schedulers.io().execute(() -> {
                try {
                    server.fetchMetadataResponse();
                }
                catch (IOException e) {
                    Logging.LOG.log(Level.WARNING, "Failed to fetch authlib-injector server metdata: " + server, e);
                }
            });
        }
    }

    public static ObservableList<Account> getAccounts() {
        return accounts;
    }

    public static ReadOnlyListProperty<Account> accountsProperty() {
        return accountsWrapper.getReadOnlyProperty();
    }

    public static Account getSelectedAccount() {
        return (Account)selectedAccount.get();
    }

    public static void setSelectedAccount(Account selectedAccount) {
        Accounts.selectedAccount.set((Object)selectedAccount);
    }

    public static ObjectProperty<Account> selectedAccountProperty() {
        return selectedAccount;
    }

    private static AuthlibInjectorArtifactProvider createAuthlibInjectorArtifactProvider() {
        String authlibinjectorLocation = System.getProperty("hmcl.authlibinjector.location");
        if (authlibinjectorLocation == null) {
            return new AuthlibInjectorDownloader(Metadata.HMCL_DIRECTORY.resolve("authlib-injector.jar"), DownloadProviders::getDownloadProvider){

                @Override
                public Optional<AuthlibInjectorArtifactInfo> getArtifactInfoImmediately() {
                    Optional<AuthlibInjectorArtifactInfo> local = super.getArtifactInfoImmediately();
                    if (local.isPresent()) {
                        return local;
                    }
                    return 2.parseArtifact(Paths.get("authlib-injector.jar", new String[0]));
                }
            };
        }
        Logging.LOG.info("Using specified authlib-injector: " + authlibinjectorLocation);
        return new SimpleAuthlibInjectorArtifactProvider(Paths.get(authlibinjectorLocation, new String[0]));
    }

    private static AuthlibInjectorServer getOrCreateAuthlibInjectorServer(String url) {
        return ConfigHolder.config().getAuthlibInjectorServers().stream().filter(server -> url.equals(server.getUrl())).findFirst().orElseGet(() -> {
            AuthlibInjectorServer server = new AuthlibInjectorServer(url);
            ConfigHolder.config().getAuthlibInjectorServers().add((Object)server);
            return server;
        });
    }

    private static void removeDanglingAuthlibInjectorAccounts() {
        accounts.stream().filter(AuthlibInjectorAccount.class::isInstance).map(AuthlibInjectorAccount.class::cast).filter(it -> !ConfigHolder.config().getAuthlibInjectorServers().contains((Object)it.getServer())).collect(Collectors.toList()).forEach(arg_0 -> accounts.remove(arg_0));
    }

    public static String getLocalizedLoginTypeName(AccountFactory<?> factory) {
        return I18n.i18n(Optional.ofNullable(unlocalizedLoginTypeNames.get(factory)).orElseThrow(() -> new IllegalArgumentException("Unrecognized account factory")));
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

