/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.GameVersion;
import org.jackhuang.hmcl.mod.ModAdviser;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.ModpackExportInfo;
import org.jackhuang.hmcl.mod.server.ServerModpackManifest;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.Zipper;

public class ServerModpackExportTask
extends Task<Void> {
    private final DefaultGameRepository repository;
    private final String versionId;
    private final ModpackExportInfo exportInfo;
    public static final ModpackExportInfo.Options OPTION = new ModpackExportInfo.Options().requireFileApi(false);

    public ServerModpackExportTask(DefaultGameRepository repository, String version, ModpackExportInfo exportInfo) {
        this.repository = repository;
        this.versionId = version;
        this.exportInfo = exportInfo.validate();
        this.onDone().register(event -> {
            if (event.isFailed()) {
                exportInfo.getOutput().toFile().delete();
            }
        });
    }

    @Override
    public void execute() throws Exception {
        ArrayList<String> blackList = new ArrayList<String>(ModAdviser.MODPACK_BLACK_LIST);
        blackList.add(this.versionId + ".jar");
        blackList.add(this.versionId + ".json");
        Logging.LOG.info("Compressing game files without some files in blacklist, including files or directories: usernamecache.json, asm, logs, backups, versions, assets, usercache.json, libraries, crash-reports, launcher_profiles.json, NVIDIA, TCNodeTracker");
        try (Zipper zip = new Zipper(this.exportInfo.getOutput());){
            Path runDirectory = this.repository.getRunDirectory(this.versionId).toPath();
            ArrayList<ModpackConfiguration.FileInformation> files = new ArrayList<ModpackConfiguration.FileInformation>();
            zip.putDirectory(runDirectory, "overrides", path -> {
                if (Modpack.acceptFile(path, blackList, this.exportInfo.getWhitelist())) {
                    Path file = runDirectory.resolve((String)path);
                    if (Files.isRegularFile(file, new LinkOption[0])) {
                        String relativePath = runDirectory.relativize(file).normalize().toString().replace(File.separatorChar, '/');
                        files.add(new ModpackConfiguration.FileInformation(relativePath, Hex.encodeHex(DigestUtils.digest("SHA-1", file))));
                    }
                    return true;
                }
                return false;
            });
            LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(this.repository.getResolvedPreservingPatchesVersion(this.versionId));
            String gameVersion = GameVersion.minecraftVersion(this.repository.getVersionJar(this.versionId)).orElseThrow(() -> new IOException("Cannot parse the version of " + this.versionId));
            ArrayList<ServerModpackManifest.Addon> addons = new ArrayList<ServerModpackManifest.Addon>();
            addons.add(new ServerModpackManifest.Addon(LibraryAnalyzer.LibraryType.MINECRAFT.getPatchId(), gameVersion));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FORGE).ifPresent(forgeVersion -> addons.add(new ServerModpackManifest.Addon(LibraryAnalyzer.LibraryType.FORGE.getPatchId(), (String)forgeVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.LITELOADER).ifPresent(liteLoaderVersion -> addons.add(new ServerModpackManifest.Addon(LibraryAnalyzer.LibraryType.LITELOADER.getPatchId(), (String)liteLoaderVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.OPTIFINE).ifPresent(optifineVersion -> addons.add(new ServerModpackManifest.Addon(LibraryAnalyzer.LibraryType.OPTIFINE.getPatchId(), (String)optifineVersion)));
            analyzer.getVersion(LibraryAnalyzer.LibraryType.FABRIC).ifPresent(fabricVersion -> addons.add(new ServerModpackManifest.Addon(LibraryAnalyzer.LibraryType.FABRIC.getPatchId(), (String)fabricVersion)));
            ServerModpackManifest manifest = new ServerModpackManifest(this.exportInfo.getName(), this.exportInfo.getAuthor(), this.exportInfo.getVersion(), this.exportInfo.getDescription(), StringUtils.removeSuffix(this.exportInfo.getFileApi(), "/"), files, addons);
            zip.putTextFile(JsonUtils.GSON.toJson(manifest), "server-manifest.json");
        }
    }
}

