/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.multimc;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.multimc.MultiMCManifest;
import org.jackhuang.hmcl.util.Lang;

public final class MultiMCInstanceConfiguration {
    private final String instanceType;
    private final String name;
    private final String gameVersion;
    private final Integer permGen;
    private final String wrapperCommand;
    private final String preLaunchCommand;
    private final String postExitCommand;
    private final String notes;
    private final String javaPath;
    private final String jvmArgs;
    private final boolean fullscreen;
    private final Integer width;
    private final Integer height;
    private final Integer maxMemory;
    private final Integer minMemory;
    private final boolean showConsole;
    private final boolean showConsoleOnError;
    private final boolean autoCloseConsole;
    private final boolean overrideMemory;
    private final boolean overrideJavaLocation;
    private final boolean overrideJavaArgs;
    private final boolean overrideConsole;
    private final boolean overrideCommands;
    private final boolean overrideWindow;
    private final MultiMCManifest mmcPack;

    private MultiMCInstanceConfiguration(String defaultName, InputStream contentStream, MultiMCManifest mmcPack) throws IOException {
        Properties p = new Properties();
        p.load(contentStream);
        this.mmcPack = mmcPack;
        this.instanceType = p.getProperty("InstanceType");
        this.autoCloseConsole = Boolean.parseBoolean(p.getProperty("AutoCloseConsole"));
        this.gameVersion = mmcPack != null ? mmcPack.getComponents().stream().filter(e -> "net.minecraft".equals(e.getUid())).findAny().orElseThrow(() -> new IOException("Malformed mmc-pack.json")).getVersion() : p.getProperty("IntendedVersion");
        this.javaPath = p.getProperty("JavaPath");
        this.jvmArgs = p.getProperty("JvmArgs");
        this.fullscreen = Boolean.parseBoolean(p.getProperty("LaunchMaximized"));
        this.maxMemory = Lang.toIntOrNull(p.getProperty("MaxMemAlloc"));
        this.minMemory = Lang.toIntOrNull(p.getProperty("MinMemAlloc"));
        this.height = Lang.toIntOrNull(p.getProperty("MinecraftWinHeight"));
        this.width = Lang.toIntOrNull(p.getProperty("MinecraftWinWidth"));
        this.overrideCommands = Boolean.parseBoolean(p.getProperty("OverrideCommands"));
        this.overrideConsole = Boolean.parseBoolean(p.getProperty("OverrideConsole"));
        this.overrideJavaArgs = Boolean.parseBoolean(p.getProperty("OverrideJavaArgs"));
        this.overrideJavaLocation = Boolean.parseBoolean(p.getProperty("OverrideJavaLocation"));
        this.overrideMemory = Boolean.parseBoolean(p.getProperty("OverrideMemory"));
        this.overrideWindow = Boolean.parseBoolean(p.getProperty("OverrideWindow"));
        this.permGen = Lang.toIntOrNull(p.getProperty("PermGen"));
        this.postExitCommand = p.getProperty("PostExitCommand");
        this.preLaunchCommand = p.getProperty("PreLaunchCommand");
        this.showConsole = Boolean.parseBoolean(p.getProperty("ShowConsole"));
        this.showConsoleOnError = Boolean.parseBoolean(p.getProperty("ShowConsoleOnError"));
        this.wrapperCommand = p.getProperty("WrapperCommand");
        this.name = defaultName;
        this.notes = Optional.ofNullable(p.getProperty("notes")).orElse("");
    }

    public MultiMCInstanceConfiguration(String instanceType, String name, String gameVersion, Integer permGen, String wrapperCommand, String preLaunchCommand, String postExitCommand, String notes, String javaPath, String jvmArgs, boolean fullscreen, Integer width, Integer height, Integer maxMemory, Integer minMemory, boolean showConsole, boolean showConsoleOnError, boolean autoCloseConsole, boolean overrideMemory, boolean overrideJavaLocation, boolean overrideJavaArgs, boolean overrideConsole, boolean overrideCommands, boolean overrideWindow) {
        this.instanceType = instanceType;
        this.name = name;
        this.gameVersion = gameVersion;
        this.permGen = permGen;
        this.wrapperCommand = wrapperCommand;
        this.preLaunchCommand = preLaunchCommand;
        this.postExitCommand = postExitCommand;
        this.notes = notes;
        this.javaPath = javaPath;
        this.jvmArgs = jvmArgs;
        this.fullscreen = fullscreen;
        this.width = width;
        this.height = height;
        this.maxMemory = maxMemory;
        this.minMemory = minMemory;
        this.showConsole = showConsole;
        this.showConsoleOnError = showConsoleOnError;
        this.autoCloseConsole = autoCloseConsole;
        this.overrideMemory = overrideMemory;
        this.overrideJavaLocation = overrideJavaLocation;
        this.overrideJavaArgs = overrideJavaArgs;
        this.overrideConsole = overrideConsole;
        this.overrideCommands = overrideCommands;
        this.overrideWindow = overrideWindow;
        this.mmcPack = null;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getName() {
        return this.name;
    }

    public String getGameVersion() {
        return this.gameVersion;
    }

    public Integer getPermGen() {
        return this.permGen;
    }

    public String getWrapperCommand() {
        return this.wrapperCommand;
    }

    public String getPreLaunchCommand() {
        return this.preLaunchCommand;
    }

    public String getPostExitCommand() {
        return this.postExitCommand;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public String getJvmArgs() {
        return this.jvmArgs;
    }

    public boolean isFullscreen() {
        return this.fullscreen;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getMaxMemory() {
        return this.maxMemory;
    }

    public Integer getMinMemory() {
        return this.minMemory;
    }

    public boolean isShowConsole() {
        return this.showConsole;
    }

    public boolean isShowConsoleOnError() {
        return this.showConsoleOnError;
    }

    public boolean isAutoCloseConsole() {
        return this.autoCloseConsole;
    }

    public boolean isOverrideMemory() {
        return this.overrideMemory;
    }

    public boolean isOverrideJavaLocation() {
        return this.overrideJavaLocation;
    }

    public boolean isOverrideJavaArgs() {
        return this.overrideJavaArgs;
    }

    public boolean isOverrideConsole() {
        return this.overrideConsole;
    }

    public boolean isOverrideCommands() {
        return this.overrideCommands;
    }

    public boolean isOverrideWindow() {
        return this.overrideWindow;
    }

    public Properties toProperties() {
        Properties p = new Properties();
        if (this.instanceType != null) {
            p.setProperty("InstanceType", this.instanceType);
        }
        p.setProperty("AutoCloseConsole", Boolean.toString(this.autoCloseConsole));
        if (this.gameVersion != null) {
            p.setProperty("IntendedVersion", this.gameVersion);
        }
        if (this.javaPath != null) {
            p.setProperty("JavaPath", this.javaPath);
        }
        if (this.jvmArgs != null) {
            p.setProperty("JvmArgs", this.jvmArgs);
        }
        p.setProperty("LaunchMaximized", Boolean.toString(this.fullscreen));
        if (this.maxMemory != null) {
            p.setProperty("MaxMemAlloc", Integer.toString(this.maxMemory));
        }
        if (this.minMemory != null) {
            p.setProperty("MinMemAlloc", Integer.toString(this.minMemory));
        }
        if (this.height != null) {
            p.setProperty("MinecraftWinHeight", Integer.toString(this.height));
        }
        if (this.width != null) {
            p.setProperty("MinecraftWinWidth", Integer.toString(this.width));
        }
        p.setProperty("OverrideCommands", Boolean.toString(this.overrideCommands));
        p.setProperty("OverrideConsole", Boolean.toString(this.overrideConsole));
        p.setProperty("OverrideJavaArgs", Boolean.toString(this.overrideJavaArgs));
        p.setProperty("OverrideJavaLocation", Boolean.toString(this.overrideJavaLocation));
        p.setProperty("OverrideMemory", Boolean.toString(this.overrideMemory));
        p.setProperty("OverrideWindow", Boolean.toString(this.overrideWindow));
        if (this.permGen != null) {
            p.setProperty("PermGen", Integer.toString(this.permGen));
        }
        if (this.postExitCommand != null) {
            p.setProperty("PostExitCommand", this.postExitCommand);
        }
        if (this.preLaunchCommand != null) {
            p.setProperty("PreLaunchCommand", this.preLaunchCommand);
        }
        p.setProperty("ShowConsole", Boolean.toString(this.showConsole));
        p.setProperty("ShowConsoleOnError", Boolean.toString(this.showConsoleOnError));
        if (this.wrapperCommand != null) {
            p.setProperty("WrapperCommand", this.wrapperCommand);
        }
        if (this.name != null) {
            p.setProperty("name", this.name);
        }
        if (this.notes != null) {
            p.setProperty("notes", this.notes);
        }
        return p;
    }

    public MultiMCManifest getMmcPack() {
        return this.mmcPack;
    }

    private static boolean testPath(Path root) {
        return Files.exists(root.resolve("instance.cfg"), new LinkOption[0]);
    }

    public static Path getRootPath(Path root) throws IOException {
        if (MultiMCInstanceConfiguration.testPath(root)) {
            return root;
        }
        Throwable throwable = null;
        try (Stream<Path> stream = Files.list(root);){
            Path candidate = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findAny().orElseThrow(() -> new IOException("Not a valid MultiMC modpack"));
            if (MultiMCInstanceConfiguration.testPath(candidate)) {
                Path path = candidate;
                return path;
            }
            try {
                throw new IOException("Not a valid MultiMC modpack");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static Modpack readMultiMCModpackManifest(Path modpackFile, Charset encoding) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

