/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.mcbbs;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.GameBuilder;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.ModpackConfiguration;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackCompletionTask;
import org.jackhuang.hmcl.mod.mcbbs.McbbsModpackManifest;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public class McbbsModpackRemoteInstallTask
extends Task<Void> {
    private final String name;
    private final DefaultDependencyManager dependency;
    private final DefaultGameRepository repository;
    private final List<Task<?>> dependencies = new LinkedList();
    private final List<Task<?>> dependents = new LinkedList();
    private final McbbsModpackManifest manifest;
    public static final String MODPACK_TYPE = "Server";

    public McbbsModpackRemoteInstallTask(DefaultDependencyManager dependencyManager, McbbsModpackManifest manifest, String name) {
        this.name = name;
        this.dependency = dependencyManager;
        this.repository = dependencyManager.getGameRepository();
        this.manifest = manifest;
        File json = this.repository.getModpackConfiguration(name);
        if (this.repository.hasVersion(name) && !json.exists()) {
            throw new IllegalArgumentException("Version " + name + " already exists.");
        }
        GameBuilder builder = dependencyManager.gameBuilder().name(name);
        for (McbbsModpackManifest.Addon addon : manifest.getAddons()) {
            builder.version(addon.getId(), addon.getVersion());
        }
        this.dependents.add(builder.buildAsync());
        this.onDone().register(event -> {
            if (event.isFailed()) {
                this.repository.removeVersionFromDisk(name);
            }
        });
        ModpackConfiguration config = null;
        try {
            if (json.exists() && !MODPACK_TYPE.equals((config = (ModpackConfiguration)JsonUtils.GSON.fromJson(FileUtils.readText(json), new TypeToken<ModpackConfiguration<McbbsModpackManifest>>(){}.getType())).getType())) {
                throw new IllegalArgumentException("Version " + name + " is not a Mcbbs modpack. Cannot update this version.");
            }
        }
        catch (JsonParseException | IOException exception) {
            // empty catch block
        }
    }

    @Override
    public List<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public List<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() throws Exception {
        this.dependencies.add(new McbbsModpackCompletionTask(this.dependency, this.name, new ModpackConfiguration<McbbsModpackManifest>(this.manifest, MODPACK_TYPE, this.manifest.getName(), this.manifest.getVersion(), Collections.emptyList())));
    }
}

