/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.mod.curse.CurseManifestFile;
import org.jackhuang.hmcl.mod.curse.CurseManifestMinecraft;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;

@Immutable
public final class CurseManifest {
    @SerializedName(value="manifestType")
    private final String manifestType;
    @SerializedName(value="manifestVersion")
    private final int manifestVersion;
    @SerializedName(value="name")
    private final String name;
    @SerializedName(value="version")
    private final String version;
    @SerializedName(value="author")
    private final String author;
    @SerializedName(value="overrides")
    private final String overrides;
    @SerializedName(value="minecraft")
    private final CurseManifestMinecraft minecraft;
    @SerializedName(value="files")
    private final List<CurseManifestFile> files;
    public static final String MINECRAFT_MODPACK = "minecraftModpack";

    public CurseManifest() {
        this(MINECRAFT_MODPACK, 1, "", "1.0", "", "overrides", new CurseManifestMinecraft(), Collections.emptyList());
    }

    public CurseManifest(String manifestType, int manifestVersion, String name, String version, String author, String overrides, CurseManifestMinecraft minecraft, List<CurseManifestFile> files) {
        this.manifestType = manifestType;
        this.manifestVersion = manifestVersion;
        this.name = name;
        this.version = version;
        this.author = author;
        this.overrides = overrides;
        this.minecraft = minecraft;
        this.files = files;
    }

    public String getManifestType() {
        return this.manifestType;
    }

    public int getManifestVersion() {
        return this.manifestVersion;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getOverrides() {
        return this.overrides;
    }

    public CurseManifestMinecraft getMinecraft() {
        return this.minecraft;
    }

    public List<CurseManifestFile> getFiles() {
        return this.files;
    }

    public CurseManifest setFiles(List<CurseManifestFile> files) {
        return new CurseManifest(this.manifestType, this.manifestVersion, this.name, this.version, this.author, this.overrides, this.minecraft, files);
    }

    public static Modpack readCurseForgeModpackManifest(Path zip, Charset encoding) throws IOException, JsonParseException {
        String json = CompressingUtils.readTextZipEntry(zip, "manifest.json", encoding);
        CurseManifest manifest = JsonUtils.fromNonNullJson(json, CurseManifest.class);
        return new Modpack(manifest.getName(), manifest.getAuthor(), manifest.getVersion(), manifest.getMinecraft().getGameVersion(), CompressingUtils.readTextZipEntryQuietly(zip, "modlist.html", encoding).orElse("No description"), encoding, manifest);
    }
}

