/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.curse;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.mod.ModManager;
import org.jackhuang.hmcl.mod.curse.CurseCompletionException;
import org.jackhuang.hmcl.mod.curse.CurseManifest;
import org.jackhuang.hmcl.mod.curse.CurseManifestFile;
import org.jackhuang.hmcl.mod.curse.CurseMetaMod;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class CurseCompletionTask
extends Task<Void> {
    private final DefaultDependencyManager dependency;
    private final DefaultGameRepository repository;
    private final ModManager modManager;
    private final String version;
    private CurseManifest manifest;
    private final List<Task<?>> dependencies = new LinkedList();
    private final AtomicBoolean allNameKnown = new AtomicBoolean(true);
    private final AtomicInteger finished = new AtomicInteger(0);
    private final AtomicBoolean notFound = new AtomicBoolean(false);

    public CurseCompletionTask(DefaultDependencyManager dependencyManager, String version) {
        this(dependencyManager, version, null);
    }

    public CurseCompletionTask(DefaultDependencyManager dependencyManager, String version, CurseManifest manifest) {
        this.dependency = dependencyManager;
        this.repository = dependencyManager.getGameRepository();
        this.modManager = this.repository.getModManager(version);
        this.version = version;
        this.manifest = manifest;
        if (manifest == null) {
            try {
                File manifestFile = new File(this.repository.getVersionRoot(version), "manifest.json");
                if (manifestFile.exists()) {
                    this.manifest = JsonUtils.GSON.fromJson(FileUtils.readText(manifestFile), CurseManifest.class);
                }
            }
            catch (Exception e) {
                Logging.LOG.log(Level.WARNING, "Unable to read CurseForge modpack manifest.json", e);
            }
        }
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isRelyingOnDependencies() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        if (this.manifest == null) {
            return;
        }
        File root = this.repository.getVersionRoot(this.version);
        CurseManifest newManifest = this.manifest.setFiles(this.manifest.getFiles().parallelStream().map(file -> {
            this.updateProgress(this.finished.incrementAndGet(), this.manifest.getFiles().size());
            if (StringUtils.isBlank(file.getFileName())) {
                try {
                    return file.withFileName(NetworkUtils.detectFileName(file.getUrl()));
                }
                catch (IOException e) {
                    try {
                        String result = NetworkUtils.doGet(NetworkUtils.toURL(String.format("https://cursemeta.dries007.net/%d/%d.json", file.getProjectID(), file.getFileID())));
                        CurseMetaMod mod = JsonUtils.fromNonNullJson(result, CurseMetaMod.class);
                        return file.withFileName(mod.getFileNameOnDisk()).withURL(mod.getDownloadURL());
                    }
                    catch (FileNotFoundException fof) {
                        Logging.LOG.log(Level.WARNING, "Could not query cursemeta for deleted mods: " + file.getUrl(), fof);
                        this.notFound.set(true);
                        return file;
                    }
                    catch (JsonParseException | IOException e2) {
                        try {
                            String result = NetworkUtils.doGet(NetworkUtils.toURL(String.format("https://addons-ecs.forgesvc.net/api/v2/addon/%d/file/%d", file.getProjectID(), file.getFileID())));
                            CurseMetaMod mod = JsonUtils.fromNonNullJson(result, CurseMetaMod.class);
                            return file.withFileName(mod.getFileName()).withURL(mod.getDownloadURL());
                        }
                        catch (FileNotFoundException fof) {
                            Logging.LOG.log(Level.WARNING, "Could not query forgesvc for deleted mods: " + file.getUrl(), fof);
                            this.notFound.set(true);
                            return file;
                        }
                        catch (JsonParseException | IOException e3) {
                            Logging.LOG.log(Level.WARNING, "Unable to fetch the file name of URL: " + file.getUrl(), e);
                            Logging.LOG.log(Level.WARNING, "Unable to fetch the file name of URL: " + file.getUrl(), e2);
                            Logging.LOG.log(Level.WARNING, "Unable to fetch the file name of URL: " + file.getUrl(), e3);
                            this.allNameKnown.set(false);
                            return file;
                        }
                    }
                }
            }
            return file;
        }).collect(Collectors.toList()));
        FileUtils.writeText(new File(root, "manifest.json"), JsonUtils.GSON.toJson(newManifest));
        for (CurseManifestFile file2 : newManifest.getFiles()) {
            if (!StringUtils.isNotBlank(file2.getFileName()) || this.modManager.hasSimpleMod(file2.getFileName())) continue;
            FileDownloadTask task = new FileDownloadTask(file2.getUrl(), this.modManager.getSimpleModPath(file2.getFileName()).toFile());
            task.setCacheRepository(this.dependency.getCacheRepository());
            task.setCaching(true);
            this.dependencies.add(task.withCounter());
        }
        if (!this.dependencies.isEmpty()) {
            this.getProperties().put("total", this.dependencies.size());
        }
    }

    @Override
    public boolean doPostExecute() {
        return true;
    }

    @Override
    public void postExecute() throws Exception {
        if (this.notFound.get()) {
            throw new CurseCompletionException(new FileNotFoundException());
        }
        if (!this.allNameKnown.get() || !this.isDependenciesSucceeded()) {
            throw new CurseCompletionException();
        }
    }
}

