/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod;

import java.util.List;
import org.jackhuang.hmcl.util.Lang;

public interface ModAdviser {
    public static final List<String> MODPACK_BLACK_LIST = Lang.immutableListOf("regex:(.*?)\\.log", "usernamecache.json", "usercache.json", "launcher_profiles.json", "launcher.pack.lzma", "backup", "pack.json", "launcher.jar", "cache", "modpack.cfg", "manifest.json", "minecraftinstance.json", ".curseclient", ".fabric", ".mixin.out", "jars", "logs", "versions", "assets", "libraries", "crash-reports", "NVIDIA", "AMD", "screenshots", "natives", "native", "$native", "server-resource-packs", "downloads", "asm", "backups", "TCNodeTracker", "CustomDISkins", "data", "CustomSkinLoader/caches");
    public static final List<String> MODPACK_SUGGESTED_BLACK_LIST = Lang.immutableListOf("fonts", "saves", "servers.dat", "options.txt", "blueprints", "optionsof.txt", "journeymap", "optionsshaders.txt", "mods/VoxelMods");

    public ModSuggestion advise(String var1, boolean var2);

    public static ModSuggestion suggestMod(String fileName, boolean isDirectory) {
        if (ModAdviser.match(MODPACK_BLACK_LIST, fileName, isDirectory)) {
            return ModSuggestion.HIDDEN;
        }
        if (ModAdviser.match(MODPACK_SUGGESTED_BLACK_LIST, fileName, isDirectory)) {
            return ModSuggestion.NORMAL;
        }
        return ModSuggestion.SUGGESTED;
    }

    public static boolean match(List<String> l, String fileName, boolean isDirectory) {
        for (String s : l) {
            if (!(isDirectory ? fileName.startsWith(s + "/") : (s.startsWith("regex:") ? fileName.matches(s.substring("regex:".length())) : fileName.equals(s)))) continue;
            return true;
        }
        return false;
    }

    public static enum ModSuggestion {
        SUGGESTED,
        NORMAL,
        HIDDEN;

    }
}

