/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.launch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.game.Argument;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.GameRepository;
import org.jackhuang.hmcl.game.LaunchOptions;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.launch.ExitWaiter;
import org.jackhuang.hmcl.launch.Launcher;
import org.jackhuang.hmcl.launch.NotDecompressingNativesException;
import org.jackhuang.hmcl.launch.PermissionException;
import org.jackhuang.hmcl.launch.ProcessCreationException;
import org.jackhuang.hmcl.launch.ProcessListener;
import org.jackhuang.hmcl.launch.StreamPump;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Log4jLevel;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.io.Unzipper;
import org.jackhuang.hmcl.util.platform.CommandBuilder;
import org.jackhuang.hmcl.util.platform.ManagedProcess;
import org.jackhuang.hmcl.util.platform.OperatingSystem;
import org.jackhuang.hmcl.util.platform.Platform;

public class DefaultLauncher
extends Launcher {
    private final Map<String, Supplier<Boolean>> forbiddens = Lang.mapOf(Pair.pair("-Xincgc", () -> this.options.getJava().getParsedVersion() >= 90));

    public DefaultLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options) {
        this(repository, version, authInfo, options, null);
    }

    public DefaultLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener) {
        this(repository, version, authInfo, options, listener, true);
    }

    public DefaultLauncher(GameRepository repository, Version version, AuthInfo authInfo, LaunchOptions options, ProcessListener listener, boolean daemon) {
        super(repository, version, authInfo, options, listener, daemon);
    }

    private CommandBuilder generateCommandLine(File nativeFolder) throws IOException {
        InetSocketAddress address;
        InetSocketAddress address2;
        Proxy proxy;
        CommandBuilder res = new CommandBuilder();
        if (StringUtils.isNotBlank(this.options.getWrapper())) {
            res.add(this.options.getWrapper());
        }
        res.add(this.options.getJava().getBinary().toString());
        res.addAllWithoutParsing(this.options.getJavaArguments());
        if (!this.options.isNoGeneratedJVMArgs()) {
            this.appendJvmArgs(res);
            res.add("-Dminecraft.client.jar=" + this.repository.getVersionJar(this.version));
            if (OperatingSystem.CURRENT_OS == OperatingSystem.OSX) {
                res.add("-Xdock:name=Minecraft " + this.version.getId());
                res.add("-Xdock:icon=" + this.repository.getAssetObject(this.version.getId(), this.version.getAssetIndex().getId(), "icons/minecraft.icns").getAbsolutePath());
            }
            if (OperatingSystem.CURRENT_OS != OperatingSystem.WINDOWS) {
                res.add("-Duser.home=" + this.options.getGameDir().getParent());
            }
            if (this.options.getJava().getParsedVersion() >= 70) {
                res.add("-XX:+UnlockExperimentalVMOptions");
                res.add("-XX:+UseG1GC");
                res.add("-XX:G1NewSizePercent=20");
                res.add("-XX:G1ReservePercent=20");
                res.add("-XX:MaxGCPauseMillis=50");
                res.add("-XX:G1HeapRegionSize=16M");
            }
            if (this.options.getMetaspace() != null && this.options.getMetaspace() > 0) {
                if (this.options.getJava().getParsedVersion() < 80) {
                    res.add("-XX:PermSize= " + this.options.getMetaspace() + "m");
                } else {
                    res.add("-XX:MetaspaceSize=" + this.options.getMetaspace() + "m");
                }
            }
            res.add("-XX:-UseAdaptiveSizePolicy");
            res.add("-XX:-OmitStackTraceInFastThrow");
            res.add("-Xmn128m");
            if (this.options.getJava().getPlatform() == Platform.BIT_32) {
                res.add("-Xss1M");
            }
            if (this.options.getMaxMemory() != null && this.options.getMaxMemory() > 0) {
                res.add("-Xmx" + this.options.getMaxMemory() + "m");
            }
            if (this.options.getMinMemory() != null && this.options.getMinMemory() > 0) {
                res.add("-Xms" + this.options.getMinMemory() + "m");
            }
            res.add("-Dfml.ignoreInvalidMinecraftCertificates=true");
            res.add("-Dfml.ignorePatchDiscrepancies=true");
        }
        if ((proxy = this.options.getProxy()) != null && StringUtils.isBlank(this.options.getProxyUser()) && StringUtils.isBlank(this.options.getProxyPass()) && (address2 = (InetSocketAddress)this.options.getProxy().address()) != null) {
            String host = address2.getHostString();
            int port = address2.getPort();
            if (proxy.type() == Proxy.Type.HTTP) {
                res.add("-Dhttp.proxyHost=" + (String)host);
                res.add("-Dhttp.proxyPort=" + port);
                res.add("-Dhttps.proxyHost=" + (String)host);
                res.add("-Dhttps.proxyPort=" + port);
            } else if (proxy.type() == Proxy.Type.SOCKS) {
                res.add("-DsocksProxyHost=" + (String)host);
                res.add("-DsocksProxyPort=" + port);
            }
        }
        LinkedList<String> classpath = new LinkedList<String>();
        for (Library library : this.version.getLibraries()) {
            File f;
            if (!library.appliesToCurrentEnvironment() || library.isNative() || !(f = this.repository.getLibraryFile(this.version, library)).exists() || !f.isFile()) continue;
            classpath.add(f.getAbsolutePath());
        }
        File jar = this.repository.getVersionJar(this.version);
        if (!jar.exists() || !jar.isFile()) {
            throw new IOException("Minecraft jar does not exist");
        }
        classpath.add(jar.getAbsolutePath());
        File gameAssets = this.repository.getActualAssetDirectory(this.version.getId(), this.version.getAssetIndex().getId());
        Map<String, String> configuration = this.getConfigurations();
        configuration.put("${classpath}", String.join((CharSequence)OperatingSystem.PATH_SEPARATOR, classpath));
        configuration.put("${natives_directory}", nativeFolder.getAbsolutePath());
        configuration.put("${game_assets}", gameAssets.getAbsolutePath());
        configuration.put("${assets_root}", gameAssets.getAbsolutePath());
        configuration.put("${libraries_directory}", this.repository.getLibrariesDirectory(this.version).getAbsolutePath());
        res.addAll(Arguments.parseArguments(this.version.getArguments().map(Arguments::getJvm).orElseGet(this::getDefaultJVMArguments), configuration));
        if (this.authInfo.getArguments() != null && this.authInfo.getArguments().getJvm() != null && !this.authInfo.getArguments().getJvm().isEmpty()) {
            res.addAll(Arguments.parseArguments(this.authInfo.getArguments().getJvm(), configuration));
        }
        res.add(this.version.getMainClass());
        res.addAll(Arguments.parseStringArguments(this.version.getMinecraftArguments().map(StringUtils::tokenize).orElseGet(LinkedList::new), configuration));
        Map<String, Boolean> features = this.getFeatures();
        this.version.getArguments().map(Arguments::getGame).ifPresent(arguments -> res.addAll(Arguments.parseArguments(arguments, configuration, features)));
        if (this.version.getMinecraftArguments().isPresent()) {
            res.addAll(Arguments.parseArguments(this.getDefaultGameArguments(), configuration, features));
        }
        if (this.authInfo.getArguments() != null && this.authInfo.getArguments().getGame() != null && !this.authInfo.getArguments().getGame().isEmpty()) {
            res.addAll(Arguments.parseArguments(this.authInfo.getArguments().getGame(), configuration, features));
        }
        if (StringUtils.isNotBlank(this.options.getServerIp())) {
            String[] args = this.options.getServerIp().split(":");
            res.add("--server");
            res.add(args[0]);
            res.add("--port");
            res.add(args.length > 1 ? args[1] : "25565");
        }
        if (this.options.isFullscreen()) {
            res.add("--fullscreen");
        }
        if (this.options.getProxy() != null && this.options.getProxy().type() == Proxy.Type.SOCKS && (address = (InetSocketAddress)this.options.getProxy().address()) != null) {
            res.add("--proxyHost");
            res.add(address.getHostString());
            res.add("--proxyPort");
            res.add(String.valueOf(address.getPort()));
            if (StringUtils.isNotBlank(this.options.getProxyUser()) && StringUtils.isNotBlank(this.options.getProxyPass())) {
                res.add("--proxyUser");
                res.add(this.options.getProxyUser());
                res.add("--proxyPass");
                res.add(this.options.getProxyPass());
            }
        }
        res.addAllWithoutParsing(this.options.getGameArguments());
        res.removeIf(it -> this.getForbiddens().containsKey(it) && this.getForbiddens().get(it).get() != false);
        return res;
    }

    public Map<String, Boolean> getFeatures() {
        return Collections.singletonMap("has_custom_resolution", this.options.getHeight() != null && this.options.getHeight() != 0 && this.options.getWidth() != null && this.options.getWidth() != 0);
    }

    protected Map<String, Supplier<Boolean>> getForbiddens() {
        return this.forbiddens;
    }

    protected List<Argument> getDefaultJVMArguments() {
        return Arguments.DEFAULT_JVM_ARGUMENTS;
    }

    protected List<Argument> getDefaultGameArguments() {
        return Arguments.DEFAULT_GAME_ARGUMENTS;
    }

    protected void appendJvmArgs(CommandBuilder result) {
    }

    public void decompressNatives(File destination) throws NotDecompressingNativesException {
        try {
            FileUtils.cleanDirectoryQuietly(destination);
            for (Library library : this.version.getLibraries()) {
                if (!library.isNative()) continue;
                new Unzipper(this.repository.getLibraryFile(this.version, library), destination).setFilter((zipEntry, isDirectory, destFile, path) -> {
                    if (!isDirectory && Files.isRegularFile(destFile, new LinkOption[0]) && Files.size(destFile) == Files.size(zipEntry)) {
                        return false;
                    }
                    String ext = FileUtils.getExtension(destFile);
                    if (ext.equals("sha1") || ext.equals("git")) {
                        return false;
                    }
                    return library.getExtract().shouldExtract(path);
                }).setReplaceExistentFile(false).unzip();
            }
        }
        catch (IOException e) {
            throw new NotDecompressingNativesException(e);
        }
    }

    protected Map<String, String> getConfigurations() {
        return Lang.mapOf(Pair.pair("${auth_player_name}", this.authInfo.getUsername()), Pair.pair("${auth_session}", this.authInfo.getAccessToken()), Pair.pair("${auth_access_token}", this.authInfo.getAccessToken()), Pair.pair("${auth_uuid}", UUIDTypeAdapter.fromUUID(this.authInfo.getUUID())), Pair.pair("${version_name}", Optional.ofNullable(this.options.getVersionName()).orElse(this.version.getId())), Pair.pair("${profile_name}", Optional.ofNullable(this.options.getProfileName()).orElse("Minecraft")), Pair.pair("${version_type}", Optional.ofNullable(this.options.getVersionType()).orElse(this.version.getType().getId())), Pair.pair("${game_directory}", this.repository.getRunDirectory(this.version.getId()).getAbsolutePath()), Pair.pair("${user_type}", "mojang"), Pair.pair("${assets_index_name}", this.version.getAssetIndex().getId()), Pair.pair("${user_properties}", this.authInfo.getUserProperties()), Pair.pair("${resolution_width}", this.options.getWidth().toString()), Pair.pair("${resolution_height}", this.options.getHeight().toString()));
    }

    @Override
    public ManagedProcess launch() throws IOException, InterruptedException {
        Process process;
        File nativeFolder = this.repository.getNativeDirectory(this.version.getId());
        List<String> rawCommandLine = this.generateCommandLine(nativeFolder).asList();
        this.decompressNatives(nativeFolder);
        File runDirectory = this.repository.getRunDirectory(this.version.getId());
        if (StringUtils.isNotBlank(this.options.getPreLaunchCommand())) {
            String versionName = Optional.ofNullable(this.options.getVersionName()).orElse(this.version.getId());
            String preLaunchCommand = this.options.getPreLaunchCommand().replace("$INST_NAME", versionName).replace("$INST_ID", versionName).replace("$INST_DIR", this.repository.getVersionRoot(this.version.getId()).getAbsolutePath()).replace("$INST_MC_DIR", this.repository.getRunDirectory(this.version.getId()).getAbsolutePath()).replace("$INST_JAVA", this.options.getJava().getBinary().toString());
            new ProcessBuilder(StringUtils.tokenize(preLaunchCommand)).directory(runDirectory).start().waitFor();
        }
        try {
            String appdata;
            ProcessBuilder builder = new ProcessBuilder(rawCommandLine).directory(runDirectory);
            if (this.listener == null) {
                builder.inheritIO();
            }
            if ((appdata = this.options.getGameDir().getAbsoluteFile().getParent()) != null) {
                builder.environment().put("APPDATA", appdata);
            }
            process = builder.start();
        }
        catch (IOException e) {
            throw new ProcessCreationException(e);
        }
        ManagedProcess p = new ManagedProcess(process, rawCommandLine);
        if (this.listener != null) {
            this.startMonitors(p, this.listener, this.daemon);
        }
        return p;
    }

    @Override
    public void makeLaunchScript(File scriptFile) throws IOException {
        boolean isWindows = OperatingSystem.WINDOWS == OperatingSystem.CURRENT_OS;
        File nativeFolder = this.repository.getNativeDirectory(this.version.getId());
        this.decompressNatives(nativeFolder);
        if (isWindows && !FileUtils.getExtension(scriptFile).equals("bat")) {
            throw new IllegalArgumentException("The extension of " + scriptFile + " is not 'bat' in Windows");
        }
        if (!isWindows && !FileUtils.getExtension(scriptFile).equals("sh")) {
            throw new IllegalArgumentException("The extension of " + scriptFile + " is not 'sh' in macOS/Linux");
        }
        if (!FileUtils.makeFile(scriptFile)) {
            throw new IOException("Script file: " + scriptFile + " cannot be created.");
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(scriptFile)));){
            if (isWindows) {
                writer.write("@echo off");
                writer.newLine();
                writer.write("set APPDATA=" + this.options.getGameDir().getAbsoluteFile().getParent());
                writer.newLine();
                writer.write(new CommandBuilder().add("cd", "/D", this.repository.getRunDirectory(this.version.getId()).getAbsolutePath()).toString());
                writer.newLine();
            }
            if (StringUtils.isNotBlank(this.options.getPreLaunchCommand())) {
                writer.write(this.options.getPreLaunchCommand());
                writer.newLine();
            }
            writer.write(this.generateCommandLine(nativeFolder).toString());
        }
        if (!scriptFile.setExecutable(true)) {
            throw new PermissionException();
        }
    }

    private void startMonitors(ManagedProcess managedProcess, ProcessListener processListener, boolean isDaemon) {
        processListener.setProcess(managedProcess);
        Thread stdout = Lang.thread(new StreamPump(managedProcess.getProcess().getInputStream(), it -> {
            processListener.onLog((String)it, Optional.ofNullable(Log4jLevel.guessLevel(it)).orElse(Log4jLevel.INFO));
            managedProcess.addLine((String)it);
        }), "stdout-pump", isDaemon);
        managedProcess.addRelatedThread(stdout);
        Thread stderr = Lang.thread(new StreamPump(managedProcess.getProcess().getErrorStream(), it -> {
            processListener.onLog((String)it, Log4jLevel.ERROR);
            managedProcess.addLine((String)it);
        }), "stderr-pump", isDaemon);
        managedProcess.addRelatedThread(stderr);
        managedProcess.addRelatedThread(Lang.thread(new ExitWaiter(managedProcess, Arrays.asList(stdout, stderr), processListener::onExit), "exit-waiter", isDaemon));
    }
}

