/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.AssetIndexInfo;
import org.jackhuang.hmcl.game.CompatibilityRule;
import org.jackhuang.hmcl.game.DownloadInfo;
import org.jackhuang.hmcl.game.DownloadType;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.LoggingInfo;
import org.jackhuang.hmcl.game.ReleaseType;
import org.jackhuang.hmcl.game.VersionNotFoundException;
import org.jackhuang.hmcl.game.VersionProvider;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.gson.JsonMap;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jetbrains.annotations.Nullable;

@Immutable
public class Version
implements Comparable<Version>,
Validation {
    private final String id;
    private final String version;
    private final Integer priority;
    private final String minecraftArguments;
    private final Arguments arguments;
    private final String mainClass;
    private final String inheritsFrom;
    private final String jar;
    private final AssetIndexInfo assetIndex;
    private final String assets;
    private final List<Library> libraries;
    private final List<CompatibilityRule> compatibilityRules;
    private final JsonMap<DownloadType, DownloadInfo> downloads;
    private final JsonMap<DownloadType, LoggingInfo> logging;
    private final ReleaseType type;
    private final Date time;
    private final Date releaseTime;
    private final Integer minimumLauncherVersion;
    private final Boolean root;
    private final Boolean hidden;
    private final List<Version> patches;
    private final transient boolean resolved;

    public Version(String id) {
        this(false, id, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, false, true, null);
    }

    public Version(String id, String version, int priority, Arguments arguments, String mainClass, List<Library> libraries) {
        this(false, id, version, priority, null, arguments, mainClass, null, null, null, null, libraries, null, null, null, null, null, null, null, null, null, null);
    }

    public Version(boolean resolved, String id, String version, Integer priority, String minecraftArguments, Arguments arguments, String mainClass, String inheritsFrom, String jar, AssetIndexInfo assetIndex, String assets, List<Library> libraries, List<CompatibilityRule> compatibilityRules, Map<DownloadType, DownloadInfo> downloads, Map<DownloadType, LoggingInfo> logging, ReleaseType type, Date time, Date releaseTime, Integer minimumLauncherVersion, Boolean hidden, Boolean root, List<Version> patches) {
        this.resolved = resolved;
        this.id = id;
        this.version = version;
        this.priority = priority;
        this.minecraftArguments = minecraftArguments;
        this.arguments = arguments;
        this.mainClass = mainClass;
        this.inheritsFrom = inheritsFrom;
        this.jar = jar;
        this.assetIndex = assetIndex;
        this.assets = assets;
        this.libraries = Lang.copyList(libraries);
        this.compatibilityRules = Lang.copyList(compatibilityRules);
        this.downloads = downloads == null ? null : new JsonMap<DownloadType, DownloadInfo>(downloads);
        this.logging = logging == null ? null : new JsonMap<DownloadType, LoggingInfo>(logging);
        this.type = type;
        this.time = time == null ? null : (Date)time.clone();
        this.releaseTime = releaseTime == null ? null : (Date)releaseTime.clone();
        this.minimumLauncherVersion = minimumLauncherVersion;
        this.hidden = hidden;
        this.root = root;
        this.patches = Lang.copyList(patches);
    }

    public Optional<String> getMinecraftArguments() {
        return Optional.ofNullable(this.minecraftArguments);
    }

    public Optional<Arguments> getArguments() {
        return Optional.ofNullable(this.arguments);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Date getTime() {
        return this.time;
    }

    public String getId() {
        return this.id;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    public int getPriority() {
        return this.priority == null ? Integer.MIN_VALUE : this.priority;
    }

    public ReleaseType getType() {
        return this.type == null ? ReleaseType.UNKNOWN : this.type;
    }

    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public String getJar() {
        return this.jar;
    }

    public String getInheritsFrom() {
        return this.inheritsFrom;
    }

    public int getMinimumLauncherVersion() {
        return this.minimumLauncherVersion == null ? 0 : this.minimumLauncherVersion;
    }

    public boolean isHidden() {
        return this.hidden == null ? false : this.hidden;
    }

    public boolean isRoot() {
        return this.root == null ? false : this.root;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isResolvedPreservingPatches() {
        return this.inheritsFrom == null && !this.resolved;
    }

    public List<Version> getPatches() {
        return this.patches == null ? Collections.emptyList() : this.patches;
    }

    public Map<DownloadType, LoggingInfo> getLogging() {
        return this.logging == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.logging);
    }

    public List<Library> getLibraries() {
        return this.libraries == null ? Collections.emptyList() : Collections.unmodifiableList(this.libraries);
    }

    public List<CompatibilityRule> getCompatibilityRules() {
        return this.compatibilityRules == null ? Collections.emptyList() : Collections.unmodifiableList(this.compatibilityRules);
    }

    public DownloadInfo getDownloadInfo() {
        String jarName;
        DownloadInfo client = this.downloads == null ? null : (DownloadInfo)this.downloads.get((Object)DownloadType.CLIENT);
        String string = jarName = this.jar == null ? this.id : this.jar;
        if (client == null) {
            return new DownloadInfo(String.format("%s%s/%s.jar", "https://s3.amazonaws.com/Minecraft.Download/versions/", jarName, jarName));
        }
        return client;
    }

    public AssetIndexInfo getAssetIndex() {
        String assetsId = this.assets == null ? "legacy" : this.assets;
        return this.assetIndex == null ? new AssetIndexInfo(assetsId, "https://s3.amazonaws.com/Minecraft.Download/indexes/" + assetsId + ".json") : this.assetIndex;
    }

    public boolean appliesToCurrentEnvironment() {
        return CompatibilityRule.appliesToCurrentEnvironment(this.compatibilityRules);
    }

    public Version resolve(VersionProvider provider) throws VersionNotFoundException {
        if (this.isResolved()) {
            return this;
        }
        return this.resolve(provider, new HashSet<String>()).markAsResolved();
    }

    protected Version merge(Version parent, boolean isPatch) {
        return new Version(true, this.id, null, null, this.minecraftArguments == null ? parent.minecraftArguments : this.minecraftArguments, Arguments.merge(parent.arguments, this.arguments), this.mainClass == null ? parent.mainClass : this.mainClass, null, this.jar == null ? parent.jar : this.jar, this.assetIndex == null ? parent.assetIndex : this.assetIndex, this.assets == null ? parent.assets : this.assets, Lang.merge(this.libraries, parent.libraries), Lang.merge(parent.compatibilityRules, this.compatibilityRules), this.downloads == null ? parent.downloads : this.downloads, this.logging == null ? parent.logging : this.logging, this.type == null ? parent.type : this.type, this.time == null ? parent.time : this.time, this.releaseTime == null ? parent.releaseTime : this.releaseTime, Lang.merge(this.minimumLauncherVersion, parent.minimumLauncherVersion, Math::max), this.hidden, true, isPatch ? parent.patches : Lang.merge(Lang.merge(parent.patches, Collections.singleton(this.toPatch())), this.patches));
    }

    protected Version resolve(VersionProvider provider, Set<String> resolvedSoFar) throws VersionNotFoundException {
        Version thisVersion;
        if (this.inheritsFrom == null) {
            thisVersion = this.isRoot() ? new Version(this.id).setPatches(this.patches).setJar(this.id) : (this.jar == null ? this.setJar(this.id) : this);
        } else if (!resolvedSoFar.add(this.id)) {
            Logging.LOG.log(Level.WARNING, "Found circular dependency versions: " + resolvedSoFar);
            thisVersion = this.jar == null ? this.setJar(this.id) : this;
        } else {
            thisVersion = this.merge(provider.getVersion(this.inheritsFrom).resolve(provider, resolvedSoFar), false);
        }
        if (this.patches != null && !this.patches.isEmpty()) {
            List sortedPatches = this.patches.stream().sorted(Comparator.comparing(Version::getPriority)).collect(Collectors.toList());
            for (Version patch : sortedPatches) {
                thisVersion = patch.setJar(null).merge(thisVersion, true);
            }
        }
        return thisVersion.setId(this.id);
    }

    private Version toPatch() {
        return this.clearPatches().setHidden(true).setId("resolved." + this.getId());
    }

    public Version resolvePreservingPatches(VersionProvider provider) throws VersionNotFoundException {
        return this.resolvePreservingPatches(provider, new HashSet<String>());
    }

    protected Version mergePreservingPatches(Version parent) {
        return parent.addPatch(this.toPatch()).addPatches(this.patches);
    }

    protected Version resolvePreservingPatches(VersionProvider provider, Set<String> resolvedSoFar) throws VersionNotFoundException {
        Version thisVersion;
        Version version = thisVersion = this.isRoot() ? this : new Version(this.id).addPatch(this.toPatch()).addPatches(this.getPatches());
        if (this.inheritsFrom != null) {
            if (!resolvedSoFar.add(this.id)) {
                Logging.LOG.log(Level.WARNING, "Found circular dependency versions: " + resolvedSoFar);
            } else {
                thisVersion = this.mergePreservingPatches(provider.getVersion(this.inheritsFrom).resolvePreservingPatches(provider, resolvedSoFar));
            }
        }
        return thisVersion.setId(this.id);
    }

    private Version markAsResolved() {
        return new Version(true, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version markAsUnresolved() {
        return new Version(false, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    private Version setHidden(Boolean hidden) {
        return new Version(true, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, hidden, this.root, this.patches);
    }

    public Version setId(String id) {
        return new Version(this.resolved, id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setVersion(String version) {
        return new Version(this.resolved, this.id, version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setPriority(Integer priority) {
        return new Version(this.resolved, this.id, this.version, priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setMinecraftArguments(String minecraftArguments) {
        return new Version(this.resolved, this.id, this.version, this.priority, minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setArguments(Arguments arguments) {
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setMainClass(String mainClass) {
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setInheritsFrom(String inheritsFrom) {
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setJar(String jar) {
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setLibraries(List<Library> libraries) {
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setLogging(Map<DownloadType, LoggingInfo> logging) {
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches);
    }

    public Version setPatches(List<Version> patches) {
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, patches);
    }

    public Version addPatch(Version ... additional) {
        return this.addPatches(Arrays.asList(additional));
    }

    public Version addPatches(@Nullable List<Version> additional) {
        Set patchIds = additional == null ? Collections.emptySet() : additional.stream().map(Version::getId).collect(Collectors.toSet());
        List<Version> patches = Lang.merge(this.patches == null ? null : (Collection)this.patches.stream().filter(patch -> !patchIds.contains(patch.getId())).collect(Collectors.toList()), additional);
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, patches);
    }

    public Version clearPatches() {
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, null);
    }

    public Version removePatchById(String patchId) {
        return new Version(this.resolved, this.id, this.version, this.priority, this.minecraftArguments, this.arguments, this.mainClass, this.inheritsFrom, this.jar, this.assetIndex, this.assets, this.libraries, this.compatibilityRules, this.downloads, this.logging, this.type, this.time, this.releaseTime, this.minimumLauncherVersion, this.hidden, this.root, this.patches == null ? null : this.patches.stream().filter(patch -> !patchId.equals(patch.getId())).collect(Collectors.toList()));
    }

    public boolean hasPatch(String patchId) {
        return this.patches != null && this.patches.stream().anyMatch(patch -> patchId.equals(patch.getId()));
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Version && Objects.equals(this.id, ((Version)obj).id);
    }

    @Override
    public int compareTo(Version o) {
        return this.id.compareTo(o.id);
    }

    public String toString() {
        return new ToStringBuilder(this).append("id", this.id).toString();
    }

    @Override
    public void validate() throws JsonParseException {
        if (StringUtils.isBlank(this.id)) {
            throw new JsonParseException("Version ID cannot be blank");
        }
        if (this.downloads != null) {
            for (Map.Entry entry : this.downloads.entrySet()) {
                if (!(entry.getKey() instanceof DownloadType)) {
                    throw new JsonParseException("Version downloads key must be DownloadType");
                }
                if (entry.getValue() instanceof DownloadInfo) continue;
                throw new JsonParseException("Version downloads value must be DownloadInfo");
            }
        }
        if (this.logging != null) {
            for (Map.Entry entry : this.logging.entrySet()) {
                if (!(entry.getKey() instanceof DownloadType)) {
                    throw new JsonParseException("Version logging key must be DownloadType");
                }
                if (entry.getValue() instanceof LoggingInfo) continue;
                throw new JsonParseException("Version logging value must be LoggingInfo");
            }
        }
    }
}

