/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.jackhuang.hmcl.game.HMCLModpackManifest;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.mod.Modpack;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.CompressingUtils;

public final class HMCLModpackManager {
    public static Modpack readHMCLModpackManifest(Path file, Charset encoding) throws IOException, JsonParseException {
        String manifestJson = CompressingUtils.readTextZipEntry(file, "modpack.json", encoding);
        Modpack manifest = JsonUtils.fromNonNullJson(manifestJson, Modpack.class).setEncoding(encoding);
        String gameJson = CompressingUtils.readTextZipEntry(file, "minecraft/pack.json", encoding);
        Version game = JsonUtils.fromNonNullJson(gameJson, Version.class);
        if (game.getJar() == null) {
            if (StringUtils.isBlank(manifest.getVersion())) {
                throw new JsonParseException("Cannot recognize the game version of modpack " + file + ".");
            }
            return manifest.setManifest(HMCLModpackManifest.INSTANCE);
        }
        return manifest.setManifest(HMCLModpackManifest.INSTANCE).setGameVersion(game.getJar());
    }
}

