/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.nio.file.Path;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Hex;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;

@Immutable
public class DownloadInfo
implements Validation {
    @SerializedName(value="url")
    private final String url;
    @SerializedName(value="sha1")
    private final String sha1;
    @SerializedName(value="size")
    private final int size;

    public DownloadInfo() {
        this("");
    }

    public DownloadInfo(String url) {
        this(url, null);
    }

    public DownloadInfo(String url, String sha1) {
        this(url, sha1, 0);
    }

    public DownloadInfo(String url, String sha1, int size) {
        this.url = url;
        this.sha1 = sha1;
        this.size = size;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSha1() {
        return this.sha1;
    }

    public int getSize() {
        return this.size;
    }

    public String toString() {
        return new ToStringBuilder(this).append("url", this.url).append("sha1", this.sha1).append("size", this.size).toString();
    }

    @Override
    public void validate() throws JsonParseException, TolerableValidationException {
        if (StringUtils.isBlank(this.url)) {
            throw new TolerableValidationException();
        }
    }

    public boolean validateChecksum(Path file, boolean defaultValue) throws IOException {
        if (this.getSha1() == null) {
            return defaultValue;
        }
        return Hex.encodeHex(DigestUtils.digest("SHA-1", file)).equalsIgnoreCase(this.getSha1());
    }
}

