/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.event;

import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.jackhuang.hmcl.event.Event;
import org.jackhuang.hmcl.event.EventPriority;
import org.jackhuang.hmcl.util.SimpleMultimap;

public final class EventManager<T extends Event> {
    private final SimpleMultimap<EventPriority, Consumer<T>> handlers = new SimpleMultimap(() -> new EnumMap(EventPriority.class), CopyOnWriteArraySet::new);

    public Consumer<T> registerWeak(Consumer<T> consumer) {
        this.register(new WeakListener(consumer));
        return consumer;
    }

    public Consumer<T> registerWeak(Consumer<T> consumer, EventPriority priority) {
        this.register(new WeakListener(consumer), priority);
        return consumer;
    }

    public void register(Consumer<T> consumer) {
        this.register(consumer, EventPriority.NORMAL);
    }

    public synchronized void register(Consumer<T> consumer, EventPriority priority) {
        if (!this.handlers.get(priority).contains(consumer)) {
            this.handlers.put(priority, consumer);
        }
    }

    public void register(Runnable runnable) {
        this.register((T t) -> runnable.run());
    }

    public void register(Runnable runnable, EventPriority priority) {
        this.register((T t) -> runnable.run(), priority);
    }

    public synchronized Event.Result fireEvent(T event) {
        for (EventPriority priority : EventPriority.values()) {
            for (Consumer<T> handler : this.handlers.get(priority)) {
                handler.accept(event);
            }
        }
        if (((Event)event).hasResult()) {
            return ((Event)event).getResult();
        }
        return Event.Result.DEFAULT;
    }

    private synchronized void removeConsumer(Consumer<T> consumer) {
        this.handlers.removeValue(consumer);
    }

    private class WeakListener
    implements Consumer<T> {
        private final WeakReference<Consumer<T>> ref;

        public WeakListener(Consumer<T> listener) {
            this.ref = new WeakReference(listener);
        }

        @Override
        public void accept(T t) {
            Consumer listener = (Consumer)this.ref.get();
            if (listener == null) {
                EventManager.this.removeConsumer(this);
            } else {
                listener.accept(t);
            }
        }
    }
}

