/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.optifine;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.VersionMismatchException;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.DefaultGameRepository;
import org.jackhuang.hmcl.game.GameVersion;
import org.jackhuang.hmcl.game.LibrariesDownloadInfo;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.LibraryDownloadInfo;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.platform.JavaVersion;
import org.jackhuang.hmcl.util.platform.SystemUtils;
import org.jenkinsci.constant_pool_scanner.ConstantPool;
import org.jenkinsci.constant_pool_scanner.ConstantPoolScanner;
import org.jenkinsci.constant_pool_scanner.ConstantType;
import org.jenkinsci.constant_pool_scanner.Utf8Constant;

public final class OptiFineInstallTask
extends Task<Version> {
    private final DefaultGameRepository gameRepository;
    private final DefaultDependencyManager dependencyManager;
    private final Version version;
    private final OptiFineRemoteVersion remote;
    private final Path installer;
    private final List<Task<?>> dependents = new LinkedList();
    private final List<Task<?>> dependencies = new LinkedList();
    private Path dest;
    private final Library optiFineLibrary;
    private final Library optiFineInstallerLibrary;

    public OptiFineInstallTask(DefaultDependencyManager dependencyManager, Version version, OptiFineRemoteVersion remoteVersion) {
        this(dependencyManager, version, remoteVersion, null);
    }

    public OptiFineInstallTask(DefaultDependencyManager dependencyManager, Version version, OptiFineRemoteVersion remoteVersion, Path installer) {
        this.dependencyManager = dependencyManager;
        this.gameRepository = dependencyManager.getGameRepository();
        this.version = version;
        this.remote = remoteVersion;
        this.installer = installer;
        String mavenVersion = this.remote.getGameVersion() + "_" + this.remote.getSelfVersion();
        this.optiFineLibrary = new Library(new Artifact("optifine", "OptiFine", mavenVersion));
        this.optiFineInstallerLibrary = new Library(new Artifact("optifine", "OptiFine", mavenVersion, "installer"), null, new LibrariesDownloadInfo(new LibraryDownloadInfo("optifine/OptiFine/" + mavenVersion + "/OptiFine-" + mavenVersion + "-installer.jar", this.remote.getUrls().get(0).toString())));
    }

    @Override
    public boolean doPreExecute() {
        return true;
    }

    @Override
    public void preExecute() throws Exception {
        this.dest = Files.createTempFile("optifine-installer", ".jar", new FileAttribute[0]);
        if (this.installer == null) {
            FileDownloadTask task = new FileDownloadTask(this.dependencyManager.getDownloadProvider().injectURLsWithCandidates(this.remote.getUrls()), this.dest.toFile(), null);
            task.setCacheRepository(this.dependencyManager.getCacheRepository());
            task.setCaching(true);
            this.dependents.add(task);
        } else {
            FileUtils.copyFile(this.installer, this.dest);
        }
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isRelyingOnDependencies() {
        return false;
    }

    @Override
    public void execute() throws Exception {
        String originalMainClass = this.version.resolve(this.dependencyManager.getGameRepository()).getMainClass();
        if (!("net.minecraft.client.main.Main".equals(originalMainClass) || "net.minecraft.launchwrapper.Launch".equals(originalMainClass) || "cpw.mods.modlauncher.Launcher".equals(originalMainClass))) {
            throw new UnsupportedOptiFineInstallationException();
        }
        LinkedList<Library> libraries = new LinkedList<Library>();
        libraries.add(this.optiFineLibrary);
        FileUtils.copyFile(this.dest, this.gameRepository.getLibraryFile(this.version, this.optiFineInstallerLibrary).toPath());
        boolean hasLaunchWrapper = false;
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(this.dest);){
            Path launchWrapperVersionText;
            if (Files.exists(fs.getPath("optifine/Patcher.class", new String[0]), new LinkOption[0])) {
                int exitCode = SystemUtils.callExternalProcess(JavaVersion.fromCurrentEnvironment().getBinary().toString(), "-cp", this.dest.toString(), "optifine.Patcher", this.gameRepository.getVersionJar(this.version).getAbsolutePath(), this.dest.toString(), this.gameRepository.getLibraryFile(this.version, this.optiFineLibrary).toString());
                if (exitCode != 0) {
                    throw new IOException("OptiFine patcher failed");
                }
            } else {
                FileUtils.copyFile(this.dest, this.gameRepository.getLibraryFile(this.version, this.optiFineLibrary).toPath());
            }
            Path launchWrapper2 = fs.getPath("launchwrapper-2.0.jar", new String[0]);
            if (Files.exists(launchWrapper2, new LinkOption[0])) {
                Library launchWrapper = new Library(new Artifact("optifine", "launchwrapper", "2.0"));
                File launchWrapperFile = this.gameRepository.getLibraryFile(this.version, launchWrapper);
                FileUtils.makeDirectory(launchWrapperFile.getAbsoluteFile().getParentFile());
                FileUtils.copyFile(launchWrapper2, launchWrapperFile.toPath());
                hasLaunchWrapper = true;
                libraries.add(launchWrapper);
            }
            if (Files.exists(launchWrapperVersionText = fs.getPath("launchwrapper-of.txt", new String[0]), new LinkOption[0])) {
                String launchWrapperVersion = FileUtils.readText(launchWrapperVersionText).trim();
                Path launchWrapperJar = fs.getPath("launchwrapper-of-" + launchWrapperVersion + ".jar", new String[0]);
                Library launchWrapper = new Library(new Artifact("optifine", "launchwrapper-of", launchWrapperVersion));
                if (Files.exists(launchWrapperJar, new LinkOption[0])) {
                    File launchWrapperFile = this.gameRepository.getLibraryFile(this.version, launchWrapper);
                    FileUtils.makeDirectory(launchWrapperFile.getAbsoluteFile().getParentFile());
                    FileUtils.copyFile(launchWrapperJar, launchWrapperFile.toPath());
                    hasLaunchWrapper = true;
                    libraries.add(launchWrapper);
                }
            }
        }
        if (!hasLaunchWrapper) {
            libraries.add(new Library(new Artifact("net.minecraft", "launchwrapper", "1.12")));
        }
        this.setResult(new Version(LibraryAnalyzer.LibraryType.OPTIFINE.getPatchId(), this.remote.getSelfVersion(), 10000, new Arguments().addGameArguments("--tweakClass", "optifine.OptiFineTweaker"), "net.minecraft.launchwrapper.Launch", libraries));
        this.dependencies.add(this.dependencyManager.checkLibraryCompletionAsync((Version)this.getResult(), true));
    }

    public static Task<Version> install(DefaultDependencyManager dependencyManager, Version version, Path installer) throws IOException, VersionMismatchException {
        File jar = dependencyManager.getGameRepository().getVersionJar(version);
        Optional<String> gameVersion = GameVersion.minecraftVersion(jar);
        if (!gameVersion.isPresent()) {
            throw new IOException();
        }
        try (FileSystem fs = CompressingUtils.createReadOnlyZipFileSystem(installer);){
            Path configClass = fs.getPath("Config.class", new String[0]);
            if (!Files.exists(configClass, new LinkOption[0])) {
                configClass = fs.getPath("net/optifine/Config.class", new String[0]);
            }
            if (!Files.exists(configClass, new LinkOption[0])) {
                throw new IOException("Unrecognized installer");
            }
            ConstantPool pool = ConstantPoolScanner.parse(Files.readAllBytes(configClass), ConstantType.UTF8);
            ArrayList constants = new ArrayList();
            pool.list(Utf8Constant.class).forEach(utf8 -> constants.add(utf8.get()));
            String mcVersion = Lang.getOrDefault(constants, constants.indexOf("MC_VERSION") + 1, null);
            String ofEdition = Lang.getOrDefault(constants, constants.indexOf("OF_EDITION") + 1, null);
            String ofRelease = Lang.getOrDefault(constants, constants.indexOf("OF_RELEASE") + 1, null);
            if (mcVersion == null || ofEdition == null || ofRelease == null) {
                throw new IOException("Unrecognized OptiFine installer");
            }
            if (!mcVersion.equals(gameVersion.get())) {
                throw new VersionMismatchException(mcVersion, gameVersion.get());
            }
            OptiFineInstallTask optiFineInstallTask = new OptiFineInstallTask(dependencyManager, version, new OptiFineRemoteVersion(mcVersion, ofEdition + "_" + ofRelease, Collections.singletonList(""), false), installer);
            return optiFineInstallTask;
        }
    }

    public static class UnsupportedOptiFineInstallationException
    extends Exception {
    }
}

