/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.optifine;

import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.optifine.OptiFineRemoteVersion;
import org.jackhuang.hmcl.download.optifine.OptiFineVersion;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class OptiFineBMCLVersionList
extends VersionList<OptiFineRemoteVersion> {
    private final String apiRoot;

    public OptiFineBMCLVersionList(String apiRoot) {
        this.apiRoot = apiRoot;
    }

    @Override
    public boolean hasType() {
        return true;
    }

    @Override
    public Task<?> refreshAsync() {
        final GetTask task = new GetTask(NetworkUtils.toURL(this.apiRoot + "/optifine/versionlist"));
        return new Task<Void>(){

            @Override
            public Collection<Task<?>> getDependents() {
                return Collections.singleton(task);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                OptiFineBMCLVersionList.this.lock.writeLock().lock();
                try {
                    OptiFineBMCLVersionList.this.versions.clear();
                    HashSet<String> duplicates = new HashSet<String>();
                    List root = (List)JsonUtils.GSON.fromJson((String)task.getResult(), new TypeToken<List<OptiFineVersion>>(){}.getType());
                    for (OptiFineVersion element : root) {
                        boolean isPre;
                        String version = element.getType() + "_" + element.getPatch();
                        String mirror = "https://bmclapi2.bangbang93.com/optifine/" + element.getGameVersion() + "/" + element.getType() + "/" + element.getPatch();
                        if (!duplicates.add(mirror)) continue;
                        boolean bl = isPre = element.getPatch() != null && (element.getPatch().startsWith("pre") || element.getPatch().startsWith("alpha"));
                        if (StringUtils.isBlank(element.getGameVersion())) continue;
                        String gameVersion = VersionNumber.normalize(element.getGameVersion());
                        OptiFineBMCLVersionList.this.versions.put(gameVersion, new OptiFineRemoteVersion(gameVersion, version, Collections.singletonList(mirror), isPre));
                    }
                }
                finally {
                    OptiFineBMCLVersionList.this.lock.writeLock().unlock();
                }
            }
        };
    }
}

