/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.liteloader;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.game.Arguments;
import org.jackhuang.hmcl.game.Artifact;
import org.jackhuang.hmcl.game.LibrariesDownloadInfo;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.LibraryDownloadInfo;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Lang;

public final class LiteLoaderInstallTask
extends Task<Version> {
    private final DefaultDependencyManager dependencyManager;
    private final Version version;
    private final LiteLoaderRemoteVersion remote;
    private final List<Task<?>> dependents = new LinkedList();
    private final List<Task<?>> dependencies = new LinkedList();

    public LiteLoaderInstallTask(DefaultDependencyManager dependencyManager, Version version, LiteLoaderRemoteVersion remoteVersion) {
        this.dependencyManager = dependencyManager;
        this.version = version;
        this.remote = remoteVersion;
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() {
        Library library = new Library(new Artifact("com.mumfrey", "liteloader", this.remote.getSelfVersion()), "http://dl.liteloader.com/versions/", new LibrariesDownloadInfo(new LibraryDownloadInfo(null, this.remote.getUrls().get(0))));
        this.setResult(new Version(LibraryAnalyzer.LibraryType.LITELOADER.getPatchId(), this.remote.getSelfVersion(), 60000, new Arguments().addGameArguments("--tweakClass", "com.mumfrey.liteloader.launch.LiteLoaderTweaker"), "net.minecraft.launchwrapper.Launch", Lang.merge(this.remote.getLibraries(), Collections.singleton(library))).setLogging(Collections.emptyMap()));
        this.dependencies.add(this.dependencyManager.checkLibraryCompletionAsync((Version)this.getResult(), true));
    }
}

