/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.liteloader;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jackhuang.hmcl.download.BMCLAPIDownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderBranch;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderGameVersions;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRemoteVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderRepository;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderVersion;
import org.jackhuang.hmcl.download.liteloader.LiteLoaderVersionsRoot;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LiteLoaderBMCLVersionList
extends VersionList<LiteLoaderRemoteVersion> {
    private final BMCLAPIDownloadProvider downloadProvider;
    public static final String LITELOADER_LIST = "http://dl.liteloader.com/versions/versions.json";

    public LiteLoaderBMCLVersionList(BMCLAPIDownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public Task<?> refreshAsync() {
        final GetTask task = new GetTask(NetworkUtils.toURL(this.downloadProvider.injectURL(LITELOADER_LIST)));
        return new Task<Void>(){

            @Override
            public Collection<Task<?>> getDependents() {
                return Collections.singleton(task);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                LiteLoaderBMCLVersionList.this.lock.writeLock().lock();
                try {
                    LiteLoaderVersionsRoot root = JsonUtils.GSON.fromJson((String)task.getResult(), LiteLoaderVersionsRoot.class);
                    LiteLoaderBMCLVersionList.this.versions.clear();
                    for (Map.Entry<String, LiteLoaderGameVersions> entry : root.getVersions().entrySet()) {
                        String gameVersion = entry.getKey();
                        LiteLoaderGameVersions liteLoader = entry.getValue();
                        String gg = VersionNumber.normalize(gameVersion);
                        this.doBranch(gg, gameVersion, liteLoader.getRepoitory(), liteLoader.getArtifacts(), false);
                        this.doBranch(gg, gameVersion, liteLoader.getRepoitory(), liteLoader.getSnapshots(), true);
                    }
                }
                finally {
                    LiteLoaderBMCLVersionList.this.lock.writeLock().unlock();
                }
            }

            private void doBranch(String key, String gameVersion, LiteLoaderRepository repository, LiteLoaderBranch branch, boolean snapshot) {
                if (branch == null || repository == null) {
                    return;
                }
                for (Map.Entry<String, LiteLoaderVersion> entry : branch.getLiteLoader().entrySet()) {
                    String branchName = entry.getKey();
                    LiteLoaderVersion v = entry.getValue();
                    if ("latest".equals(branchName)) continue;
                    String version = v.getVersion();
                    String url = "https://bmclapi2.bangbang93.com/liteloader/download?version=" + version;
                    if (snapshot) {
                        try {
                            version = version.replace("SNAPSHOT", LiteLoaderBMCLVersionList.getLatestSnapshotVersion(repository.getUrl() + "com/mumfrey/liteloader/" + v.getVersion() + "/"));
                            url = repository.getUrl() + "com/mumfrey/liteloader/" + v.getVersion() + "/liteloader-" + version + "-release.jar";
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    LiteLoaderBMCLVersionList.this.versions.put(key, new LiteLoaderRemoteVersion(gameVersion, version, Collections.singletonList(url), v.getTweakClass(), v.getLibraries()));
                }
            }
        };
    }

    private static String getLatestSnapshotVersion(String repo) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(repo + "maven-metadata.xml");
        Element r = doc.getDocumentElement();
        Element snapshot = (Element)r.getElementsByTagName("snapshot").item(0);
        Node timestamp = snapshot.getElementsByTagName("timestamp").item(0);
        Node buildNumber = snapshot.getElementsByTagName("buildNumber").item(0);
        return timestamp.getTextContent() + "-" + buildNumber.getTextContent();
    }
}

