/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.RemoteVersion;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;

public final class VersionJsonDownloadTask
extends Task<String> {
    private final String gameVersion;
    private final DefaultDependencyManager dependencyManager;
    private final List<Task<?>> dependents = new LinkedList();
    private final List<Task<?>> dependencies = new LinkedList();
    private final VersionList<?> gameVersionList;

    public VersionJsonDownloadTask(String gameVersion, DefaultDependencyManager dependencyManager) {
        this.gameVersion = gameVersion;
        this.dependencyManager = dependencyManager;
        this.gameVersionList = dependencyManager.getVersionList("game");
        this.dependents.add(this.gameVersionList.loadAsync());
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public void execute() throws IOException {
        RemoteVersion remoteVersion = (RemoteVersion)this.gameVersionList.getVersion(this.gameVersion, this.gameVersion).orElseThrow(() -> new IOException("Cannot find specific version " + this.gameVersion + " in remote repository"));
        this.dependencies.add(new GetTask(this.dependencyManager.getDownloadProvider().injectURLsWithCandidates(remoteVersion.getUrls())).storeTo(this::setResult));
    }
}

