/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.util.Collection;
import java.util.Collections;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.download.game.GameRemoteVersionInfo;
import org.jackhuang.hmcl.download.game.GameRemoteVersions;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;

public final class GameVersionList
extends VersionList<GameRemoteVersion> {
    private final DownloadProvider downloadProvider;

    public GameVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return true;
    }

    @Override
    protected Collection<GameRemoteVersion> getVersionsImpl(String gameVersion) {
        return this.versions.values();
    }

    @Override
    public Task<?> refreshAsync() {
        final GetTask task = new GetTask(NetworkUtils.toURL(this.downloadProvider.getVersionListURL()));
        return new Task<Void>(){

            @Override
            public Collection<Task<?>> getDependents() {
                return Collections.singleton(task);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                GameVersionList.this.lock.writeLock().lock();
                try {
                    GameVersionList.this.versions.clear();
                    GameRemoteVersions root = JsonUtils.GSON.fromJson((String)task.getResult(), GameRemoteVersions.class);
                    for (GameRemoteVersionInfo remoteVersion : root.getVersions()) {
                        GameVersionList.this.versions.put(remoteVersion.getGameVersion(), new GameRemoteVersion(remoteVersion.getGameVersion(), remoteVersion.getGameVersion(), Collections.singletonList(remoteVersion.getUrl()), remoteVersion.getType(), remoteVersion.getReleaseTime()));
                    }
                }
                finally {
                    GameVersionList.this.lock.writeLock().unlock();
                }
            }
        };
    }
}

