/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jackhuang.hmcl.download.DefaultDependencyManager;
import org.jackhuang.hmcl.download.LibraryAnalyzer;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.io.CompressingUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class GameVerificationFixTask
extends Task<Void> {
    private final DefaultDependencyManager dependencyManager;
    private final String gameVersion;
    private final Version version;
    private final List<Task<?>> dependencies = new LinkedList();

    public GameVerificationFixTask(DefaultDependencyManager dependencyManager, String gameVersion, Version version) {
        this.dependencyManager = dependencyManager;
        this.gameVersion = gameVersion;
        this.version = version;
        if (!version.isResolved()) {
            throw new IllegalArgumentException("GameVerificationFixTask requires a resolved game version");
        }
        this.setSignificance(Task.TaskSignificance.MODERATE);
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() throws IOException {
        File jar = this.dependencyManager.getGameRepository().getVersionJar(this.version);
        LibraryAnalyzer analyzer = LibraryAnalyzer.analyze(this.version);
        if (jar.exists() && VersionNumber.VERSION_COMPARATOR.compare(this.gameVersion, "1.6") < 0 && analyzer.has(LibraryAnalyzer.LibraryType.FORGE)) {
            try (FileSystem fs = CompressingUtils.createWritableZipFileSystem(jar.toPath(), StandardCharsets.UTF_8);){
                Files.deleteIfExists(fs.getPath("META-INF/MOJANG_C.DSA", new String[0]));
                Files.deleteIfExists(fs.getPath("META-INF/MOJANG_C.SF", new String[0]));
            }
        }
    }
}

