/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.game;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.jackhuang.hmcl.download.AbstractDependencyManager;
import org.jackhuang.hmcl.download.game.GameAssetIndexDownloadTask;
import org.jackhuang.hmcl.game.AssetIndex;
import org.jackhuang.hmcl.game.AssetIndexInfo;
import org.jackhuang.hmcl.game.AssetObject;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.FileUtils;

public final class GameAssetDownloadTask
extends Task<Void> {
    private final AbstractDependencyManager dependencyManager;
    private final Version version;
    private final AssetIndexInfo assetIndexInfo;
    private final File assetIndexFile;
    private final boolean integrityCheck;
    private final List<Task<?>> dependents = new LinkedList();
    private final List<Task<?>> dependencies = new LinkedList();
    public static final boolean DOWNLOAD_INDEX_FORCIBLY = true;
    public static final boolean DOWNLOAD_INDEX_IF_NECESSARY = false;

    public GameAssetDownloadTask(AbstractDependencyManager dependencyManager, Version version, boolean forceDownloadingIndex, boolean integrityCheck) {
        this.dependencyManager = dependencyManager;
        this.version = version.resolve(dependencyManager.getGameRepository());
        this.assetIndexInfo = this.version.getAssetIndex();
        this.assetIndexFile = dependencyManager.getGameRepository().getIndexFile(version.getId(), this.assetIndexInfo.getId());
        this.integrityCheck = integrityCheck;
        this.dependents.add(new GameAssetIndexDownloadTask(dependencyManager, this.version, forceDownloadingIndex));
    }

    @Override
    public Collection<Task<?>> getDependents() {
        return this.dependents;
    }

    @Override
    public Collection<Task<?>> getDependencies() {
        return this.dependencies;
    }

    @Override
    public void execute() throws Exception {
        AssetIndex index;
        try {
            index = JsonUtils.fromNonNullJson(FileUtils.readText(this.assetIndexFile), AssetIndex.class);
        }
        catch (JsonParseException | IOException e) {
            throw new GameAssetIndexDownloadTask.GameAssetIndexMalformedException();
        }
        int progress = 0;
        for (AssetObject assetObject : index.getObjects().values()) {
            if (this.isCancelled()) {
                throw new InterruptedException();
            }
            File file = this.dependencyManager.getGameRepository().getAssetObject(this.version.getId(), this.assetIndexInfo.getId(), assetObject);
            boolean download = !file.isFile();
            try {
                if (!download && this.integrityCheck && !assetObject.validateChecksum(file.toPath(), true)) {
                    download = true;
                }
            }
            catch (IOException e) {
                Logging.LOG.log(Level.WARNING, "Unable to calc hash value of file " + file.toPath(), e);
            }
            if (download) {
                List<URL> urls = this.dependencyManager.getDownloadProvider().getAssetObjectCandidates(assetObject.getLocation());
                FileDownloadTask task = new FileDownloadTask(urls, file, new FileDownloadTask.IntegrityCheck("SHA-1", assetObject.getHash()));
                task.setName(assetObject.getHash());
                task.setCandidate(this.dependencyManager.getCacheRepository().getCommonDirectory().resolve("assets").resolve("objects").resolve(assetObject.getLocation()));
                task.setCacheRepository(this.dependencyManager.getCacheRepository());
                task.setCaching(true);
                this.dependencies.add(task.withCounter());
            } else {
                this.dependencyManager.getCacheRepository().tryCacheFile(file.toPath(), "SHA-1", assetObject.getHash());
            }
            this.updateProgress(++progress, index.getObjects().size());
        }
        if (!this.dependencies.isEmpty()) {
            this.getProperties().put("total", this.dependencies.size());
        }
    }
}

