/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.forge;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jackhuang.hmcl.download.DownloadProvider;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.download.forge.ForgeVersion;
import org.jackhuang.hmcl.download.forge.ForgeVersionRoot;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.versioning.VersionNumber;

public final class ForgeVersionList
extends VersionList<ForgeRemoteVersion> {
    private final DownloadProvider downloadProvider;
    public static final String FORGE_LIST = "https://files.minecraftforge.net/maven/net/minecraftforge/forge/json";

    public ForgeVersionList(DownloadProvider downloadProvider) {
        this.downloadProvider = downloadProvider;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public Task<?> refreshAsync() {
        final GetTask task = new GetTask(NetworkUtils.toURL(this.downloadProvider.injectURL(FORGE_LIST)));
        return new Task<Void>(){

            @Override
            public Collection<Task<?>> getDependents() {
                return Collections.singleton(task);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                ForgeVersionList.this.lock.writeLock().lock();
                try {
                    ForgeVersionRoot root = JsonUtils.GSON.fromJson((String)task.getResult(), ForgeVersionRoot.class);
                    if (root == null) {
                        return;
                    }
                    ForgeVersionList.this.versions.clear();
                    for (Map.Entry<String, int[]> entry : root.getGameVersions().entrySet()) {
                        String gameVersion = VersionNumber.normalize(entry.getKey());
                        for (int v : entry.getValue()) {
                            ForgeVersion version = root.getNumber().get(v);
                            if (version == null) continue;
                            String jar = null;
                            for (String[] file : version.getFiles()) {
                                if (file.length <= 1 || !"installer".equals(file[1])) continue;
                                String classifier = version.getGameVersion() + "-" + version.getVersion() + (StringUtils.isNotBlank(version.getBranch()) ? "-" + version.getBranch() : "");
                                String fileName = root.getArtifact() + "-" + classifier + "-" + file[1] + "." + file[0];
                                jar = root.getWebPath() + classifier + "/" + fileName;
                            }
                            if (jar == null) continue;
                            ForgeVersionList.this.versions.put(gameVersion, new ForgeRemoteVersion(version.getGameVersion(), version.getVersion(), Collections.singletonList(jar)));
                        }
                    }
                }
                finally {
                    ForgeVersionList.this.lock.writeLock().unlock();
                }
            }
        };
    }
}

