/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download.forge;

import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jackhuang.hmcl.download.VersionList;
import org.jackhuang.hmcl.download.forge.ForgeRemoteVersion;
import org.jackhuang.hmcl.task.GetTask;
import org.jackhuang.hmcl.task.Task;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ForgeBMCLVersionList
extends VersionList<ForgeRemoteVersion> {
    private final String apiRoot;

    public ForgeBMCLVersionList(String apiRoot) {
        this.apiRoot = apiRoot;
    }

    @Override
    public boolean hasType() {
        return false;
    }

    @Override
    public Task<?> loadAsync() {
        throw new UnsupportedOperationException("ForgeBMCLVersionList does not support loading the entire Forge remote version list.");
    }

    @Override
    public Task<?> refreshAsync() {
        throw new UnsupportedOperationException("ForgeBMCLVersionList does not support loading the entire Forge remote version list.");
    }

    @Override
    public Task<?> refreshAsync(final String gameVersion) {
        final GetTask task = new GetTask(NetworkUtils.toURL(this.apiRoot + "/forge/minecraft/" + gameVersion));
        return new Task<Void>(){

            @Override
            public Collection<Task<?>> getDependents() {
                return Collections.singleton(task);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute() {
                ForgeBMCLVersionList.this.lock.writeLock().lock();
                try {
                    List forgeVersions = (List)JsonUtils.GSON.fromJson((String)task.getResult(), new TypeToken<List<ForgeVersion>>(){}.getType());
                    ForgeBMCLVersionList.this.versions.clear(gameVersion);
                    if (forgeVersions == null) {
                        return;
                    }
                    for (ForgeVersion version : forgeVersions) {
                        if (version == null) continue;
                        ArrayList<String> urls = new ArrayList<String>();
                        for (ForgeVersion.File file : version.getFiles()) {
                            if (!"installer".equals(file.getCategory()) || !"jar".equals(file.getFormat())) continue;
                            String classifier = gameVersion + "-" + version.getVersion() + (StringUtils.isNotBlank(version.getBranch()) ? "-" + version.getBranch() : "");
                            String fileName1 = "forge-" + classifier + "-" + file.getCategory() + "." + file.getFormat();
                            String fileName2 = "forge-" + classifier + "-" + gameVersion + "-" + file.getCategory() + "." + file.getFormat();
                            urls.add("https://files.minecraftforge.net/maven/net/minecraftforge/forge/" + classifier + "/" + fileName1);
                            urls.add("https://files.minecraftforge.net/maven/net/minecraftforge/forge/" + classifier + "-" + gameVersion + "/" + fileName2);
                            urls.add(NetworkUtils.withQuery("https://bmclapi2.bangbang93.com/forge/download", Lang.mapOf(Pair.pair("mcversion", version.getGameVersion()), Pair.pair("version", version.getVersion()), Pair.pair("branch", version.getBranch()), Pair.pair("category", file.getCategory()), Pair.pair("format", file.getFormat()))));
                        }
                        if (urls.isEmpty()) continue;
                        ForgeBMCLVersionList.this.versions.put(gameVersion, new ForgeRemoteVersion(version.getGameVersion(), version.getVersion(), urls));
                    }
                }
                finally {
                    ForgeBMCLVersionList.this.lock.writeLock().unlock();
                }
            }
        };
    }

    @Override
    public Optional<ForgeRemoteVersion> getVersion(String gameVersion, String remoteVersion) {
        remoteVersion = StringUtils.substringAfter(remoteVersion, "-", remoteVersion);
        return super.getVersion(gameVersion, remoteVersion);
    }

    @Immutable
    public static final class ForgeVersion
    implements Validation {
        private final String branch;
        private final String mcversion;
        private final String version;
        private final List<File> files;

        public ForgeVersion() {
            this(null, null, null, null);
        }

        public ForgeVersion(String branch, String mcversion, String version, List<File> files) {
            this.branch = branch;
            this.mcversion = mcversion;
            this.version = version;
            this.files = files;
        }

        @Nullable
        public String getBranch() {
            return this.branch;
        }

        @NotNull
        public String getGameVersion() {
            return this.mcversion;
        }

        @NotNull
        public String getVersion() {
            return this.version;
        }

        @NotNull
        public List<File> getFiles() {
            return this.files;
        }

        @Override
        public void validate() throws JsonParseException {
            if (this.files == null) {
                throw new JsonParseException("ForgeVersion files cannot be null");
            }
            if (this.version == null) {
                throw new JsonParseException("ForgeVersion version cannot be null");
            }
            if (this.mcversion == null) {
                throw new JsonParseException("ForgeVersion mcversion cannot be null");
            }
        }

        @Immutable
        public static final class File {
            private final String format;
            private final String category;
            private final String hash;

            public File() {
                this("", "", "");
            }

            public File(String format, String category, String hash) {
                this.format = format;
                this.category = category;
                this.hash = hash;
            }

            public String getFormat() {
                return this.format;
            }

            public String getCategory() {
                return this.category;
            }

            public String getHash() {
                return this.hash;
            }
        }
    }
}

