/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.download;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jackhuang.hmcl.game.Library;
import org.jackhuang.hmcl.game.Version;
import org.jackhuang.hmcl.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibraryAnalyzer
implements Iterable<LibraryMark> {
    private Version version;
    private final Map<String, Pair<Library, String>> libraries;
    public static final String VANILLA_MAIN = "net.minecraft.client.main.Main";
    public static final String LAUNCH_WRAPPER_MAIN = "net.minecraft.launchwrapper.Launch";
    public static final String MOD_LAUNCHER_MAIN = "cpw.mods.modlauncher.Launcher";

    private LibraryAnalyzer(Version version, Map<String, Pair<Library, String>> libraries) {
        this.version = version;
        this.libraries = libraries;
    }

    public Optional<String> getVersion(LibraryType type) {
        return this.getVersion(type.getPatchId());
    }

    public Optional<String> getVersion(String type) {
        return Optional.ofNullable(this.libraries.get(type)).map(Pair::getValue);
    }

    @Override
    @NotNull
    public Iterator<LibraryMark> iterator() {
        return new Iterator<LibraryMark>(){
            Iterator<Map.Entry<String, Pair<Library, String>>> impl;
            {
                this.impl = LibraryAnalyzer.this.libraries.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.impl.hasNext();
            }

            @Override
            public LibraryMark next() {
                Map.Entry<String, Pair<Library, String>> entry = this.impl.next();
                return new LibraryMark(entry.getKey(), entry.getValue().getValue());
            }
        };
    }

    public boolean has(LibraryType type) {
        return this.has(type.getPatchId());
    }

    public boolean has(String type) {
        return this.libraries.containsKey(type);
    }

    public boolean hasModLoader() {
        return this.libraries.keySet().stream().map(LibraryType::fromPatchId).filter(Objects::nonNull).anyMatch(LibraryType::isModLoader);
    }

    public boolean hasModLauncher() {
        String modLauncher = MOD_LAUNCHER_MAIN;
        return MOD_LAUNCHER_MAIN.equals(this.version.getMainClass()) || this.version.getPatches().stream().anyMatch(patch -> MOD_LAUNCHER_MAIN.equals(patch.getMainClass()));
    }

    private Version removingMatchedLibrary(Version version, String libraryId) {
        LibraryType type = LibraryType.fromPatchId(libraryId);
        if (type == null) {
            return version;
        }
        ArrayList<Library> libraries = new ArrayList<Library>();
        for (Library library : version.getLibraries()) {
            if (type.matchLibrary(library)) continue;
            libraries.add(library);
        }
        return version.setLibraries(libraries);
    }

    public LibraryAnalyzer removeLibrary(String libraryId) {
        if (!this.has(libraryId)) {
            return this;
        }
        this.version = this.removingMatchedLibrary(this.version, libraryId).setPatches(this.version.getPatches().stream().filter(patch -> !libraryId.equals(patch.getId())).map(patch -> this.removingMatchedLibrary((Version)patch, libraryId)).collect(Collectors.toList()));
        return this;
    }

    public Version build() {
        return this.version;
    }

    public static LibraryAnalyzer analyze(Version version) {
        if (version.getInheritsFrom() != null) {
            throw new IllegalArgumentException("LibraryAnalyzer can only analyze independent game version");
        }
        HashMap<String, Pair<Library, String>> libraries = new HashMap<String, Pair<Library, String>>();
        block0: for (Library library : version.resolve(null).getLibraries()) {
            for (LibraryType type : LibraryType.values()) {
                if (!type.matchLibrary(library)) continue;
                libraries.put(type.getPatchId(), Pair.pair(library, library.getVersion()));
                continue block0;
            }
        }
        for (Version patch : version.getPatches()) {
            if (patch.isHidden()) continue;
            libraries.put(patch.getId(), Pair.pair(null, patch.getVersion()));
        }
        return new LibraryAnalyzer(version, libraries);
    }

    public static class LibraryMark {
        private final String libraryId;
        private final String libraryVersion;

        public LibraryMark(@NotNull String libraryId, @Nullable String libraryVersion) {
            this.libraryId = libraryId;
            this.libraryVersion = libraryVersion;
        }

        @NotNull
        public String getLibraryId() {
            return this.libraryId;
        }

        @Nullable
        public String getLibraryVersion() {
            return this.libraryVersion;
        }
    }

    public static enum LibraryType {
        MINECRAFT(true, "game", Pattern.compile("^$"), Pattern.compile("^$")),
        FABRIC(true, "fabric", Pattern.compile("net\\.fabricmc"), Pattern.compile("fabric-loader")),
        FORGE(true, "forge", Pattern.compile("net\\.minecraftforge"), Pattern.compile("forge")),
        LITELOADER(true, "liteloader", Pattern.compile("com\\.mumfrey"), Pattern.compile("liteloader")),
        OPTIFINE(false, "optifine", Pattern.compile("(net\\.)?optifine"), Pattern.compile("^(?!.*launchwrapper).*$"));

        private final boolean modLoader;
        private final String patchId;
        private final Pattern group;
        private final Pattern artifact;

        private LibraryType(boolean modLoader, String patchId, Pattern group, Pattern artifact) {
            this.modLoader = modLoader;
            this.patchId = patchId;
            this.group = group;
            this.artifact = artifact;
        }

        public boolean isModLoader() {
            return this.modLoader;
        }

        public String getPatchId() {
            return this.patchId;
        }

        public static LibraryType fromPatchId(String patchId) {
            for (LibraryType type : LibraryType.values()) {
                if (!type.getPatchId().equals(patchId)) continue;
                return type;
            }
            return null;
        }

        public boolean matchLibrary(Library library) {
            return this.group.matcher(library.getGroupId()).matches() && this.artifact.matcher(library.getArtifactId()).matches();
        }
    }
}

