/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.offline;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import org.jackhuang.hmcl.auth.AccountFactory;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.offline.OfflineAccount;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;

public class OfflineAccountFactory
extends AccountFactory<OfflineAccount> {
    public static final OfflineAccountFactory INSTANCE = new OfflineAccountFactory();

    private OfflineAccountFactory() {
    }

    @Override
    public AccountFactory.AccountLoginType getLoginType() {
        return AccountFactory.AccountLoginType.USERNAME;
    }

    public OfflineAccount create(String username, UUID uuid) {
        return new OfflineAccount(username, uuid);
    }

    @Override
    public OfflineAccount create(CharacterSelector selector, String username, String password, Object additionalData) {
        return new OfflineAccount(username, OfflineAccountFactory.getUUIDFromUserName(username));
    }

    @Override
    public OfflineAccount fromStorage(Map<Object, Object> storage) {
        String username = Lang.tryCast(storage.get("username"), String.class).orElseThrow(() -> new IllegalStateException("Offline account configuration malformed."));
        UUID uuid = Lang.tryCast(storage.get("uuid"), String.class).map(UUIDTypeAdapter::fromString).orElse(OfflineAccountFactory.getUUIDFromUserName(username));
        return new OfflineAccount(username, uuid);
    }

    private static UUID getUUIDFromUserName(String username) {
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + username).getBytes(StandardCharsets.UTF_8));
    }
}

