/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.offline;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.ToStringBuilder;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;

public class OfflineAccount
extends Account {
    private final String username;
    private final UUID uuid;

    protected OfflineAccount(String username, UUID uuid) {
        this.username = Objects.requireNonNull(username);
        this.uuid = Objects.requireNonNull(uuid);
        if (StringUtils.isBlank(username)) {
            throw new IllegalArgumentException("Username cannot be blank");
        }
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getCharacter() {
        return this.username;
    }

    @Override
    public AuthInfo logIn() {
        return new AuthInfo(this.username, this.uuid, UUIDTypeAdapter.fromUUID(UUID.randomUUID()), "{}");
    }

    @Override
    public AuthInfo logInWithPassword(String password) throws AuthenticationException {
        return this.logIn();
    }

    @Override
    public Optional<AuthInfo> playOffline() {
        return Optional.of(this.logIn());
    }

    @Override
    public Map<Object, Object> toStorage() {
        return Lang.mapOf(Pair.pair("uuid", UUIDTypeAdapter.fromUUID(this.uuid)), Pair.pair("username", this.username));
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("username", this.username).append("uuid", this.uuid).toString();
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OfflineAccount)) {
            return false;
        }
        OfflineAccount another = (OfflineAccount)obj;
        return this.username.equals(another.username);
    }
}

