/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.microsoft;

import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.gson.UUIDTypeAdapter;

public class MicrosoftSession {
    private final String tokenType;
    private final String accessToken;
    private final User user;
    private final GameProfile profile;

    public MicrosoftSession(String tokenType, String accessToken, User user, GameProfile profile) {
        this.tokenType = tokenType;
        this.accessToken = accessToken;
        this.user = user;
        this.profile = profile;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAuthorization() {
        return String.format("%s %s", this.getTokenType(), this.getAccessToken());
    }

    public User getUser() {
        return this.user;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    public static MicrosoftSession fromStorage(Map<?, ?> storage) {
        UUID uuid = Lang.tryCast(storage.get("uuid"), String.class).map(UUIDTypeAdapter::fromString).orElseThrow(() -> new IllegalArgumentException("uuid is missing"));
        String name = Lang.tryCast(storage.get("displayName"), String.class).orElseThrow(() -> new IllegalArgumentException("displayName is missing"));
        String tokenType = Lang.tryCast(storage.get("tokenType"), String.class).orElseThrow(() -> new IllegalArgumentException("tokenType is missing"));
        String accessToken = Lang.tryCast(storage.get("accessToken"), String.class).orElseThrow(() -> new IllegalArgumentException("accessToken is missing"));
        String userId = Lang.tryCast(storage.get("userid"), String.class).orElseThrow(() -> new IllegalArgumentException("userid is missing"));
        return new MicrosoftSession(tokenType, accessToken, new User(userId), new GameProfile(uuid, name));
    }

    public Map<Object, Object> toStorage() {
        Objects.requireNonNull(this.profile);
        Objects.requireNonNull(this.user);
        return Lang.mapOf(Pair.pair("tokenType", this.tokenType), Pair.pair("accessToken", this.accessToken), Pair.pair("uuid", UUIDTypeAdapter.fromUUID(this.profile.getId())), Pair.pair("displayName", this.profile.getName()), Pair.pair("userid", this.user.id));
    }

    public AuthInfo toAuthInfo() {
        Objects.requireNonNull(this.profile);
        return new AuthInfo(this.profile.getName(), this.profile.getId(), this.accessToken, "{}");
    }

    public static class GameProfile {
        private final UUID id;
        private final String name;

        public GameProfile(UUID id, String name) {
            this.id = id;
            this.name = name;
        }

        public UUID getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class User {
        private final String id;

        public User(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

