/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.microsoft;

import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.NoCharacterException;
import org.jackhuang.hmcl.auth.NoSelectedCharacterException;
import org.jackhuang.hmcl.auth.ServerDisconnectException;
import org.jackhuang.hmcl.auth.ServerResponseMalformedException;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftSession;
import org.jackhuang.hmcl.auth.yggdrasil.RemoteAuthenticationException;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Logging;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.gson.TolerableValidationException;
import org.jackhuang.hmcl.util.gson.Validation;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jackhuang.hmcl.util.javafx.ObservableOptionalCache;

public class MicrosoftService {
    private static final ThreadPoolExecutor POOL = Lang.threadPool("MicrosoftProfileProperties", true, 2, 10L, TimeUnit.SECONDS);
    private static final Pattern OAUTH_URL_PATTERN = Pattern.compile("^https://login\\.live\\.com/oauth20_desktop\\.srf\\?code=(.*?)&lc=(.*?)$");
    private final WebViewCallback callback;
    private final ObservableOptionalCache<String, MinecraftProfileResponse, AuthenticationException> profileRepository;

    public MicrosoftService(WebViewCallback callback) {
        this.callback = callback;
        this.profileRepository = new ObservableOptionalCache(authorization -> {
            Logging.LOG.info("Fetching properties");
            return this.getCompleteProfile((String)authorization);
        }, (uuid, e) -> Logging.LOG.log(Level.WARNING, "Failed to fetch properties of " + uuid, (Throwable)e), POOL);
    }

    public ObservableOptionalCache<String, MinecraftProfileResponse, AuthenticationException> getProfileRepository() {
        return this.profileRepository;
    }

    public MicrosoftSession authenticate() throws AuthenticationException {
        Objects.requireNonNull(this.callback);
        try {
            String code = (String)((CompletableFuture)this.callback.show(this, urlToBeTested -> OAUTH_URL_PATTERN.matcher((CharSequence)urlToBeTested).find(), "https://login.live.com/oauth20_authorize.srf?client_id=00000000402b5328&response_type=code&scope=service%3A%3Auser.auth.xboxlive.com%3A%3AMBI_SSL&redirect_uri=https%3A%2F%2Flogin.live.com%2Foauth20_desktop.srf").thenApply(url -> {
                Matcher matcher = OAUTH_URL_PATTERN.matcher((CharSequence)url);
                matcher.find();
                return matcher.group(1);
            })).get();
            String responseText = HttpRequest.POST("https://login.live.com/oauth20_token.srf").form(Lang.mapOf(Pair.pair("client_id", "00000000402b5328"), Pair.pair("code", code), Pair.pair("grant_type", "authorization_code"), Pair.pair("redirect_uri", "https://login.live.com/oauth20_desktop.srf"), Pair.pair("scope", "service::user.auth.xboxlive.com::MBI_SSL"))).getString();
            LiveAuthorizationResponse response = JsonUtils.fromNonNullJson(responseText, LiveAuthorizationResponse.class);
            XBoxLiveAuthenticationResponse xboxResponse = HttpRequest.POST("https://user.auth.xboxlive.com/user/authenticate").json(Lang.mapOf(Pair.pair("Properties", Lang.mapOf(Pair.pair("AuthMethod", "RPS"), Pair.pair("SiteName", "user.auth.xboxlive.com"), Pair.pair("RpsTicket", response.accessToken))), Pair.pair("RelyingParty", "http://auth.xboxlive.com"), Pair.pair("TokenType", "JWT"))).getJson(XBoxLiveAuthenticationResponse.class);
            String uhs = (String)xboxResponse.displayClaims.xui.get(0).get("uhs");
            XBoxLiveAuthenticationResponse xstsResponse = HttpRequest.POST("https://xsts.auth.xboxlive.com/xsts/authorize").json(Lang.mapOf(Pair.pair("Properties", Lang.mapOf(Pair.pair("SandboxId", "RETAIL"), Pair.pair("UserTokens", Collections.singletonList(xboxResponse.token)))), Pair.pair("RelyingParty", "rp://api.minecraftservices.com/"), Pair.pair("TokenType", "JWT"))).getJson(XBoxLiveAuthenticationResponse.class);
            MinecraftLoginWithXBoxResponse minecraftResponse = HttpRequest.POST("https://api.minecraftservices.com/authentication/login_with_xbox").json(Lang.mapOf(Pair.pair("identityToken", "XBL3.0 x=" + uhs + ";" + xstsResponse.token))).getJson(MinecraftLoginWithXBoxResponse.class);
            MinecraftStoreResponse storeResponse = HttpRequest.GET("https://api.minecraftservices.com/entitlements/mcstore").authorization(String.format("%s %s", minecraftResponse.tokenType, minecraftResponse.accessToken)).getJson(MinecraftStoreResponse.class);
            MicrosoftService.handleErrorResponse(storeResponse);
            if (storeResponse.items.isEmpty()) {
                throw new NoCharacterException();
            }
            return new MicrosoftSession(minecraftResponse.tokenType, minecraftResponse.accessToken, new MicrosoftSession.User(minecraftResponse.username), null);
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
        catch (InterruptedException e) {
            throw new NoSelectedCharacterException();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof InterruptedException) {
                throw new NoSelectedCharacterException();
            }
            throw new ServerDisconnectException(e);
        }
        catch (JsonParseException e) {
            throw new ServerResponseMalformedException(e);
        }
    }

    public MicrosoftSession refresh(MicrosoftSession oldSession) throws AuthenticationException {
        try {
            MinecraftProfileResponse profileResponse = HttpRequest.GET(NetworkUtils.toURL("https://api.minecraftservices.com/minecraft/profile")).authorization(String.format("%s %s", oldSession.getTokenType(), oldSession.getAccessToken())).getJson(MinecraftProfileResponse.class);
            MicrosoftService.handleErrorResponse(profileResponse);
            return new MicrosoftSession(oldSession.getTokenType(), oldSession.getAccessToken(), oldSession.getUser(), new MicrosoftSession.GameProfile(profileResponse.id, profileResponse.name));
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
        catch (JsonParseException e) {
            throw new ServerResponseMalformedException(e);
        }
    }

    public Optional<MinecraftProfileResponse> getCompleteProfile(String authorization) throws AuthenticationException {
        try {
            return Optional.ofNullable(HttpRequest.GET(NetworkUtils.toURL("https://api.minecraftservices.com/minecraft/profile")).authorization(authorization).getJson(MinecraftProfileResponse.class));
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
        catch (JsonParseException e) {
            throw new ServerResponseMalformedException(e);
        }
    }

    public boolean validate(String tokenType, String accessToken) throws AuthenticationException {
        Objects.requireNonNull(tokenType);
        Objects.requireNonNull(accessToken);
        try {
            HttpRequest.GET(NetworkUtils.toURL("https://api.minecraftservices.com/minecraft/profile")).authorization(String.format("%s %s", tokenType, accessToken)).filter((url, responseCode) -> {
                if (responseCode / 100 == 4) {
                    throw new ResponseCodeException((URL)url, (int)responseCode);
                }
            }).getString();
            return true;
        }
        catch (ResponseCodeException e) {
            return false;
        }
        catch (IOException e) {
            throw new ServerDisconnectException(e);
        }
    }

    private static void handleErrorResponse(MinecraftErrorResponse response) throws AuthenticationException {
        if (response.error != null) {
            throw new RemoteAuthenticationException(response.error, response.errorMessage, response.developerMessage);
        }
    }

    public static Optional<Map<TextureType, Texture>> getTextures(MinecraftProfileResponse profile) {
        Objects.requireNonNull(profile);
        EnumMap<TextureType, Texture> textures = new EnumMap<TextureType, Texture>(TextureType.class);
        if (!profile.skins.isEmpty()) {
            textures.put(TextureType.SKIN, new Texture(profile.skins.get((int)0).url, null));
        }
        return Optional.of(textures);
    }

    private static class LiveAuthorizationResponse {
        @SerializedName(value="token_type")
        String tokenType;
        @SerializedName(value="expires_in")
        int expiresIn;
        @SerializedName(value="scope")
        String scope;
        @SerializedName(value="access_token")
        String accessToken;
        @SerializedName(value="refresh_token")
        String refreshToken;
        @SerializedName(value="user_id")
        String userId;
        @SerializedName(value="foci")
        String foci;

        private LiveAuthorizationResponse() {
        }
    }

    private static class MinecraftErrorResponse {
        public String path;
        public String errorType;
        public String error;
        public String errorMessage;
        public String developerMessage;

        private MinecraftErrorResponse() {
        }
    }

    private static class MinecraftLoginWithXBoxResponse {
        @SerializedName(value="username")
        String username;
        @SerializedName(value="roles")
        List<String> roles;
        @SerializedName(value="access_token")
        String accessToken;
        @SerializedName(value="token_type")
        String tokenType;
        @SerializedName(value="expires_in")
        int expiresIn;

        private MinecraftLoginWithXBoxResponse() {
        }
    }

    public static class MinecraftProfileResponse
    extends MinecraftErrorResponse
    implements Validation {
        @SerializedName(value="id")
        UUID id;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="skins")
        List<MinecraftProfileResponseSkin> skins;
        @SerializedName(value="capes")
        List<MinecraftProfileResponseCape> capes;

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            Validation.requireNonNull(this.id, "id cannot be null");
            Validation.requireNonNull(this.name, "name cannot be null");
            Validation.requireNonNull(this.skins, "skins cannot be null");
            Validation.requireNonNull(this.capes, "capes cannot be null");
        }
    }

    public static class MinecraftProfileResponseCape {
    }

    public static class MinecraftProfileResponseSkin
    implements Validation {
        public String id;
        public String state;
        public String url;
        public String variant;
        public String alias;

        @Override
        public void validate() throws JsonParseException, TolerableValidationException {
            Validation.requireNonNull(this.id, "id cannot be null");
            Validation.requireNonNull(this.state, "state cannot be null");
            Validation.requireNonNull(this.url, "url cannot be null");
            Validation.requireNonNull(this.variant, "variant cannot be null");
        }
    }

    private static class MinecraftStoreResponse
    extends MinecraftErrorResponse {
        @SerializedName(value="items")
        List<MinecraftStoreResponseItem> items;
        @SerializedName(value="signature")
        String signature;
        @SerializedName(value="keyId")
        String keyId;

        private MinecraftStoreResponse() {
        }
    }

    private static class MinecraftStoreResponseItem {
        @SerializedName(value="name")
        String name;
        @SerializedName(value="signature")
        String signature;

        private MinecraftStoreResponseItem() {
        }
    }

    public static interface WebViewCallback {
        public CompletableFuture<String> show(MicrosoftService var1, Predicate<String> var2, String var3);
    }

    private static class XBoxLiveAuthenticationResponse {
        @SerializedName(value="IssueInstant")
        String issueInstant;
        @SerializedName(value="NotAfter")
        String notAfter;
        @SerializedName(value="Token")
        String token;
        @SerializedName(value="DisplayClaims")
        XBoxLiveAuthenticationResponseDisplayClaims displayClaims;

        private XBoxLiveAuthenticationResponse() {
        }
    }

    private static class XBoxLiveAuthenticationResponseDisplayClaims {
        List<Map<Object, Object>> xui;

        private XBoxLiveAuthenticationResponseDisplayClaims() {
        }
    }
}

