/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.microsoft;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javafx.beans.binding.ObjectBinding;
import org.jackhuang.hmcl.auth.Account;
import org.jackhuang.hmcl.auth.AuthInfo;
import org.jackhuang.hmcl.auth.AuthenticationException;
import org.jackhuang.hmcl.auth.CharacterSelector;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftService;
import org.jackhuang.hmcl.auth.microsoft.MicrosoftSession;
import org.jackhuang.hmcl.auth.yggdrasil.Texture;
import org.jackhuang.hmcl.auth.yggdrasil.TextureType;
import org.jackhuang.hmcl.util.javafx.BindingMapping;

public class MicrosoftAccount
extends Account {
    protected final MicrosoftService service;
    protected UUID characterUUID;
    private boolean authenticated = false;
    private MicrosoftSession session;

    protected MicrosoftAccount(MicrosoftService service, MicrosoftSession session) {
        this.service = Objects.requireNonNull(service);
        this.session = Objects.requireNonNull(session);
        this.characterUUID = Objects.requireNonNull(session.getProfile().getId());
    }

    protected MicrosoftAccount(MicrosoftService service, CharacterSelector characterSelector) throws AuthenticationException {
        this.service = Objects.requireNonNull(service);
        MicrosoftSession acquiredSession = service.authenticate();
        this.session = acquiredSession.getProfile() == null ? service.refresh(acquiredSession) : acquiredSession;
        this.characterUUID = this.session.getProfile().getId();
        this.authenticated = true;
    }

    @Override
    public String getUsername() {
        return "";
    }

    @Override
    public String getCharacter() {
        return this.session.getProfile().getName();
    }

    @Override
    public UUID getUUID() {
        return this.session.getProfile().getId();
    }

    @Override
    public AuthInfo logIn() throws AuthenticationException {
        if (!this.authenticated) {
            if (this.service.validate(this.session.getTokenType(), this.session.getAccessToken())) {
                this.authenticated = true;
            } else {
                MicrosoftSession acquiredSession = this.service.authenticate();
                this.session = acquiredSession.getProfile() == null ? this.service.refresh(acquiredSession) : acquiredSession;
                this.characterUUID = this.session.getProfile().getId();
                this.authenticated = true;
            }
        }
        return this.session.toAuthInfo();
    }

    @Override
    public AuthInfo logInWithPassword(String password) throws AuthenticationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<AuthInfo> playOffline() {
        return Optional.of(this.session.toAuthInfo());
    }

    @Override
    public Map<Object, Object> toStorage() {
        return this.session.toStorage();
    }

    public MicrosoftService getService() {
        return this.service;
    }

    @Override
    public ObjectBinding<Optional<Map<TextureType, Texture>>> getTextures() {
        return BindingMapping.of(this.service.getProfileRepository().binding(this.session.getAuthorization())).map(profile -> profile.flatMap(MicrosoftService::getTextures));
    }

    @Override
    public void clearCache() {
        this.authenticated = false;
    }

    @Override
    public String toString() {
        return "MicrosoftAccount[uuid=" + this.characterUUID + ", name=" + this.getCharacter() + "]";
    }

    public int hashCode() {
        return this.characterUUID.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MicrosoftAccount that = (MicrosoftAccount)o;
        return this.characterUUID.equals(that.characterUUID);
    }
}

